/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.xml;

import com.biotechvana.phylograph.TreeElement;
import com.biotechvana.phylograph.readers.ColorReader;
import com.biotechvana.phylograph.readers.FontReader;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Xml2TreeList2 {
    private TreeElement treeList;
    private double maxLength = 0.0;
    private ColorReader colorReader = new ColorReader();
    private FontReader fontReader = new FontReader();

    public Xml2TreeList2(File input) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            doc = factory.newDocumentBuilder().parse(input);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        if (doc == null) {
            System.out.println("No existe el fichero");
            System.exit(0);
        }
        Element root = doc.getDocumentElement();
        this.treeList = this.createTreeList(root, this.treeList);
    }

    public TreeElement createTreeList(Element parent, TreeElement father) {
        boolean node = false;
        int id = Integer.parseInt(parent.getAttribute("id"));
        int level = Integer.parseInt(parent.getAttribute("level"));
        double length = Double.parseDouble(parent.getAttribute("length"));
        double bootstrap = Double.parseDouble(parent.getAttribute("bootstrap"));
        Color colorLine = this.colorReader.getColor(parent.getAttribute("colorline"));
        boolean visible = Boolean.parseBoolean(parent.getAttribute("visible"));
        if (parent.getAttribute("node").equalsIgnoreCase("true")) {
            node = true;
        }
        if (Double.parseDouble(parent.getAttribute("length")) > this.maxLength) {
            this.maxLength = Double.parseDouble(parent.getAttribute("length"));
        }
        TreeElement treeElement = new TreeElement(node, id, level, length, bootstrap, father);
        treeElement.setText(parent.getAttribute("text"));
        treeElement.setColorLine(colorLine);
        treeElement.setVisible(visible);
        if (!node) {
            Color colorText = this.colorReader.getColor(parent.getAttribute("fontColor"));
            Font font = this.fontReader.getFont(parent.getAttribute("font"));
            String link = parent.getAttribute("link");
            String cluster = parent.getAttribute("cluster");
            treeElement.setColorText(colorText);
            treeElement.setFont(font);
            treeElement.setLink(link);
            treeElement.setCluster(cluster);
        }
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            try {
                treeElement.add(this.createTreeList((Element)children.item(i), treeElement));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return treeElement;
    }

    public TreeElement getTreeList() {
        return this.treeList;
    }

    public double getMaxLength() {
        return this.maxLength;
    }
}

