/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.xml;

import com.biotechvana.phylograph.InternalF;
import com.biotechvana.phylograph.components.ClusterFull;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLToCluster {
    public List<ClusterFull> readClusters(InternalF internalF, File xmlInput) {
        ArrayList<ClusterFull> clusterList = new ArrayList<ClusterFull>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            doc = factory.newDocumentBuilder().parse(xmlInput);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        if (doc == null) {
            System.out.println("No existe el fichero");
            System.exit(0);
        }
        Element root = doc.getDocumentElement();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String componentType = children.item(i).getNodeName().trim();
            if (!componentType.equalsIgnoreCase("cluster")) continue;
            NamedNodeMap namedNodeMap = children.item(i).getAttributes();
            String clusterName = namedNodeMap.getNamedItem("name").getNodeValue();
            String[] otuNames = this.getOtuList(internalF, children.item(i));
            ClusterFull cluster = this.createCluster(internalF, clusterName, otuNames);
            clusterList.add(cluster);
        }
        return clusterList;
    }

    private String[] getOtuList(InternalF internalF, Node label) {
        NodeList children = label.getChildNodes();
        ArrayList<String> otuList = new ArrayList<String>();
        for (int i = 0; i < children.getLength(); ++i) {
            String otuName = children.item(i).getTextContent().trim();
            if (otuName == null || otuName.length() <= 0) continue;
            otuList.add(otuName);
        }
        return otuList.toArray(new String[otuList.size()]);
    }

    private ClusterFull createCluster(InternalF internalF, String clusterName, String[] otuNames) {
        ClusterFull clusterFull = new ClusterFull(internalF, clusterName, otuNames);
        return clusterFull;
    }

    public void print(List<ClusterFull> clusterList) {
        for (ClusterFull cluster : clusterList) {
            System.out.println("cluster name:" + cluster.getText());
            String[] otuNames = cluster.getOtuNames();
            for (int i = 0; i < otuNames.length; ++i) {
                System.out.println("\t" + i + ":" + otuNames[i]);
            }
            System.out.println("");
        }
    }
}

