/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.xml;

import com.biotechvana.phylograph.TreeElement;
import com.biotechvana.phylograph.components.Node;
import com.biotechvana.phylograph.components.Otu;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class TreeList2Xml {
    Otu[] otuArray;
    Node[] nodeArray;

    public void createXmlFile(TreeElement parent, File filename, Otu[] otuArray, Node[] nodeArray) {
        this.otuArray = otuArray;
        this.nodeArray = nodeArray;
        StringBuffer sbuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        sbuffer.append(this.getXMLTree(parent, ""));
        if (filename != null) {
            try {
                FileWriter fw = new FileWriter(filename);
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(sbuffer.toString());
                bw.close();
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getXMLTree(TreeElement parent, String tab) {
        StringBuffer sb = new StringBuffer();
        sb.append("\r\n" + tab + "<element");
        sb.append(" id=\"" + String.valueOf(parent.getId()) + "\"");
        sb.append(" node=\"" + String.valueOf(parent.isNode()) + "\"");
        sb.append(" level=\"" + String.valueOf(parent.getLevel()) + "\"");
        sb.append(" length=\"" + String.valueOf(parent.getLength()) + "\"");
        sb.append(" bootstrap=\"" + String.valueOf(parent.getBootstrap()) + "\"");
        sb.append(" visible=\"" + String.valueOf(parent.isVisible()) + "\"");
        sb.append(" text=\"" + String.valueOf(parent.getText()) + "\"");
        sb.append(" colorline=\"" + String.valueOf(parent.getColorLine()) + "\"");
        if (!parent.isNode()) {
            sb.append(" font=\"" + String.valueOf(this.otuArray[parent.getId()].getFont()) + "\"");
            sb.append(" fontColor=\"" + String.valueOf(this.otuArray[parent.getId()].getForeground()) + "\"");
        } else {
            sb.append(" cluster=\"" + String.valueOf(this.nodeArray[parent.getId()].getCluster()) + "\"");
        }
        sb.append(">");
        for (int i = 0; i < parent.size(); ++i) {
            try {
                sb.append(this.getXMLTree((TreeElement)parent.get(i), tab + "\t"));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        sb.append("\r\n" + tab + "</element>");
        return sb.toString();
    }
}

