/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.xml;

import com.biotechvana.phylograph.components.Bracket;
import com.biotechvana.phylograph.components.Scale;
import com.biotechvana.phylograph.components.TextLabel;
import com.biotechvana.phylograph.utils.StringToFile;
import java.io.File;
import java.util.List;

public class Components2XML {
    public void createXmlFile(File filename, List<?> textLabelList, List<?> bracketList, Scale scale) {
        StringToFile stringToFile = new StringToFile();
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        sbuffer.append("<components>\n");
        if (textLabelList != null && textLabelList.size() > 0) {
            sbuffer.append(this.createLabelText(textLabelList));
        }
        if (bracketList != null && bracketList.size() > 0) {
            sbuffer.append(this.createBracketText(bracketList));
        }
        if (scale != null) {
            sbuffer.append(this.createScaleText(scale));
        }
        sbuffer.append("</components>\n");
        stringToFile.saveFile(filename, sbuffer.toString());
    }

    private String createLabelText(List<?> textLabelList) {
        StringBuffer sbuffer = new StringBuffer();
        for (int i = 0; i < textLabelList.size(); ++i) {
            TextLabel textLabel = (TextLabel)textLabelList.get(i);
            try {
                sbuffer.append("\n<label");
                sbuffer.append(" id=\"" + String.valueOf(i) + "\"");
                sbuffer.append(" x=\"" + String.valueOf(textLabel.getX()) + "\"");
                sbuffer.append(" y=\"" + String.valueOf(textLabel.getY()) + "\"");
                sbuffer.append(" w=\"" + String.valueOf(textLabel.getWidth()) + "\"");
                sbuffer.append(" h=\"" + String.valueOf(textLabel.getHeight()) + "\"");
                sbuffer.append(" paddingX=\"" + String.valueOf(textLabel.getPaddingX()) + "\"");
                sbuffer.append(" paddingY=\"" + String.valueOf(textLabel.getPaddingY()) + "\"");
                sbuffer.append(" horizontal=\"" + String.valueOf(textLabel.isHorizontal()) + "\"");
                sbuffer.append(" transparent=\"" + String.valueOf(textLabel.isTransparent()) + "\"");
                sbuffer.append(" font=\"" + String.valueOf(textLabel.getFont()) + "\"");
                sbuffer.append(" colorText=\"" + String.valueOf(textLabel.getColorText()) + "\"");
                sbuffer.append(" colorBack=\"" + String.valueOf(textLabel.getColorBack()) + "\"");
                sbuffer.append(" colorBorder=\"" + String.valueOf(textLabel.getColorBorder()) + "\"");
                if (textLabel.hasBorder()) {
                    sbuffer.append(" border=\"true\"");
                } else {
                    sbuffer.append(" border=\"false\"");
                }
                sbuffer.append(">");
                sbuffer.append(textLabel.getHText());
                sbuffer.append("</label>");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sbuffer.toString();
    }

    private String createBracketText(List<?> bracketList) {
        StringBuffer sbuffer = new StringBuffer();
        for (int i = 0; i < bracketList.size(); ++i) {
            Bracket bracket = (Bracket)bracketList.get(i);
            try {
                sbuffer.append("\n<bracket");
                sbuffer.append(" id=\"" + String.valueOf(i) + "\"");
                sbuffer.append(" x=\"" + String.valueOf(bracket.getX()) + "\"");
                sbuffer.append(" y=\"" + String.valueOf(bracket.getY()) + "\"");
                sbuffer.append(" w=\"" + String.valueOf(bracket.getWidth()) + "\"");
                sbuffer.append(" h=\"" + String.valueOf(bracket.getHeight()) + "\"");
                sbuffer.append(" colorLine=\"" + String.valueOf(bracket.getColorLine()) + "\"");
                sbuffer.append(" />");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sbuffer.toString();
    }

    private String createScaleText(Scale scale) {
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append("\n<scale");
        sbuffer.append(" x=\"" + String.valueOf(scale.getX()) + "\"");
        sbuffer.append(" y=\"" + String.valueOf(scale.getY()) + "\"");
        sbuffer.append(" w=\"" + String.valueOf(scale.getWidth()) + "\"");
        sbuffer.append(" h=\"" + String.valueOf(scale.getHeight()) + "\"");
        sbuffer.append(" font=\"" + String.valueOf(scale.getFont()) + "\"");
        sbuffer.append(" colorScale=\"" + String.valueOf(scale.getColorScale()) + "\"");
        sbuffer.append(" />\n");
        return sbuffer.toString();
    }
}

