/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.utils;

import com.biotechvana.phylograph.TreeElement;
import com.biotechvana.phylograph.utils.ToPolar;
import com.biotechvana.phylograph.utils.Wedge;
import java.util.ArrayList;
import java.util.Arrays;

public class ImproveUnrooted {
    private static final double pi2 = Math.PI * 2;
    private TreeElement treeList;
    private ToPolar polar = new ToPolar();
    private double[] wedgeDist;
    private double mediaWedge;
    private double[] wedgeDiff;
    private ArrayList<Wedge> wedgeList = new ArrayList();
    private ArrayList<String> angleList = new ArrayList();

    public void setTreeList(TreeElement treeList) {
        this.treeList = treeList;
        this.treeTraversal(treeList);
    }

    private void treeTraversal(TreeElement parent) {
        if (parent.isNode()) {
            this.wedgeList.clear();
            if (this.setWedges(parent)) {
                this.getWedgeDistances(parent);
                this.getWedgeMean();
                this.getWedgeDiff();
                this.setWedgesRecursive(parent);
            }
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.treeTraversal((TreeElement)parent.get(i));
        }
    }

    private boolean setWedges(TreeElement parent) {
        double[] resFather = null;
        double[] wedFather = null;
        double[] resChild = null;
        double[] wedChild = null;
        for (int i = 0; i < parent.size(); ++i) {
            TreeElement child = (TreeElement)parent.get(i);
            resChild = this.getAnglesChildren(parent, child);
            wedChild = this.getWedgeChildren(parent.getT(), parent.getW(), resChild);
            this.wedgeList.add(new Wedge(wedChild[0], wedChild[1]));
        }
        if (!parent.isRoot()) {
            resFather = this.getAnglesFather(parent);
            Wedge firstWedge = this.wedgeList.get(0);
            Wedge lastWedge = this.wedgeList.get(this.wedgeList.size() - 1);
            wedFather = this.getWedgeFather(lastWedge.getAl(), firstWedge.getAr(), resFather);
            this.wedgeList.add(new Wedge(wedFather[0], wedFather[1]));
        }
        return true;
    }

    public double[] getAnglesFather(TreeElement parent) {
        this.angleList = new ArrayList();
        this.getAnglesFather2(this.treeList, parent);
        double[] angles = new double[this.angleList.size()];
        for (int i = 0; i < this.angleList.size(); ++i) {
            angles[i] = Float.parseFloat(this.angleList.get(i).toString());
        }
        Arrays.sort(angles);
        return angles;
    }

    private void getAnglesFather2(TreeElement parent, TreeElement active) {
        if (parent.equals(active)) {
            return;
        }
        double angle = this.polar.getAngle(active.getX(), active.getY(), parent.getX(), parent.getY());
        this.angleList.add(String.valueOf(angle));
        for (int i = 0; i < parent.size(); ++i) {
            this.getAnglesFather2((TreeElement)parent.get(i), active);
        }
    }

    public double[] getAnglesChildren(TreeElement father, TreeElement parent) {
        this.angleList.clear();
        this.angleList = new ArrayList();
        this.getAnglesChildren2(father, parent);
        double[] angles = new double[this.angleList.size()];
        for (int i = 0; i < this.angleList.size(); ++i) {
            angles[i] = Float.parseFloat(this.angleList.get(i).toString());
        }
        Arrays.sort(angles);
        return angles;
    }

    private void getAnglesChildren2(TreeElement father, TreeElement parent) {
        double angle = this.polar.getAngle(father.getX(), father.getY(), parent.getX(), parent.getY());
        this.angleList.add(String.valueOf(angle));
        for (int i = 0; i < parent.size(); ++i) {
            this.getAnglesChildren2(father, (TreeElement)parent.get(i));
        }
    }

    public double[] getWedgeChildren(double t, double w, double[] angles) {
        if (t > 0.0) {
            t %= Math.PI * 2;
        } else if (t < 0.0) {
            t = Math.PI * 2 + t;
        }
        double tw = t + w;
        if (tw > 0.0) {
            tw %= Math.PI * 2;
        } else if (tw < 0.0) {
            tw = Math.PI * 2 + tw;
        }
        double right = angles[0];
        boolean rightFound = false;
        for (int i = 0; i < angles.length && !rightFound; ++i) {
            if (!(angles[i] >= tw)) continue;
            right = angles[i];
            rightFound = true;
        }
        if (!rightFound) {
            right = angles[0];
        }
        double left = angles[0];
        boolean leftFound = false;
        for (int i = angles.length - 1; i >= 0 && !leftFound; --i) {
            if (!(angles[i] <= t)) continue;
            left = angles[i];
            leftFound = true;
        }
        if (!leftFound) {
            left = angles[angles.length - 1];
        }
        double[] res = new double[]{right, left};
        return res;
    }

    public double[] getWedgeFather(double ar, double al, double[] angles) {
        if (ar > 0.0) {
            ar %= Math.PI * 2;
        } else if (ar < 0.0) {
            ar = Math.PI * 2 + ar;
        }
        if (al > 0.0) {
            al %= Math.PI * 2;
        } else if (al < 0.0) {
            al = Math.PI * 2 + al;
        }
        boolean rightFound = false;
        double rightValue = angles[0];
        for (int i = 0; i < angles.length && !rightFound; ++i) {
            if (!(angles[i] > ar)) continue;
            rightFound = true;
            rightValue = angles[i];
        }
        if (!rightFound) {
            rightValue = angles[0];
        }
        boolean leftFound = false;
        double leftValue = angles[angles.length - 1];
        for (int i = angles.length - 1; i >= 0 && !leftFound; --i) {
            if (!(angles[i] < al)) continue;
            leftFound = true;
            leftValue = angles[i];
        }
        if (!leftFound) {
            leftValue = angles[angles.length - 1];
        }
        double[] res = new double[]{rightValue, leftValue};
        return res;
    }

    private void getWedgeDistances(TreeElement parent) {
        double b;
        this.wedgeDist = new double[this.wedgeList.size()];
        for (int i = 0; i < this.wedgeList.size() - 1; ++i) {
            double b2;
            Wedge child = this.wedgeList.get(i);
            Wedge next = this.wedgeList.get(i + 1);
            double a = next.getAr();
            if (a < (b2 = child.getAl())) {
                a += Math.PI * 2;
            }
            this.wedgeDist[i] = Math.abs(a - b2);
        }
        int lastIndex = this.wedgeDist.length - 1;
        double a = this.wedgeList.get(0).getAr();
        if (a < (b = this.wedgeList.get(lastIndex).getAl())) {
            a += Math.PI * 2;
        }
        this.wedgeDist[lastIndex] = Math.abs(a - b);
    }

    private void getWedgeMean() {
        double sum = 0.0;
        for (int i = 0; i < this.wedgeDist.length; ++i) {
            sum += this.wedgeDist[i];
        }
        this.mediaWedge = sum / (double)this.wedgeDist.length;
    }

    private void getWedgeDiff() {
        this.wedgeDiff = new double[this.wedgeDist.length];
        for (int i = 0; i < this.wedgeDist.length; ++i) {
            this.wedgeDiff[i] = this.mediaWedge - this.wedgeDist[i];
        }
    }

    private void setWedgesRecursive(TreeElement parent) {
        if (parent.isRoot()) {
            for (int i = 1; i < parent.size(); ++i) {
                this.setCoordsRecursive((TreeElement)parent.get(i), this.wedgeDiff[0]);
            }
            this.setCoordsRecursive((TreeElement)parent.get(parent.size() - 1), this.wedgeDiff[1]);
        } else {
            for (int i = 0; i < parent.size(); ++i) {
                this.setCoordsRecursive((TreeElement)parent.get(i), this.wedgeDiff[this.wedgeDiff.length - 1]);
            }
            this.setCoordsRecursive((TreeElement)parent.get(parent.size() - 1), this.wedgeDiff[0]);
        }
    }

    private void setCoordsRecursive(TreeElement parent, double wedgeD) {
        if (!parent.isRoot()) {
            TreeElement father = parent.getFather();
            double coordX = 0.0;
            double coordY = 0.0;
            double lengthParent = Math.abs(parent.getLength()) * 1.0;
            double newT = parent.getT() + wedgeD;
            newT = newT > 0.0 ? (newT %= Math.PI * 2) : (newT < 0.0 ? Math.PI * 2 + newT : 0.0);
            parent.setT(newT);
            coordX = Math.cos(parent.getT() + parent.getW() / 2.0) * lengthParent;
            coordY = Math.sin(parent.getT() + parent.getW() / 2.0) * lengthParent;
            double newCoordX = father.getX() + coordX;
            double newCoordY = father.getY() + coordY;
            parent.setX(newCoordX);
            parent.setY(newCoordY);
            for (int i = 0; i < parent.size(); ++i) {
                this.setCoordsRecursive((TreeElement)parent.get(i), wedgeD);
            }
        }
    }
}

