/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.treeutils;

import com.biotechvana.phylograph.TreeElement;

public class TreePrinter {
    public void printTree(TreeElement parent, String tab) {
        System.out.print((String)tab);
        System.out.print("[ " + parent.getText() + " ]");
        System.out.print(":");
        System.out.print(" id: " + parent.getId());
        System.out.print(" | level: " + parent.getLevel());
        System.out.print(" | x: " + parent.getX());
        System.out.print(" | y: " + parent.getY());
        System.out.print(" | length: " + parent.getLength());
        System.out.print(" | boot: " + parent.getBootstrap());
        tab = (String)tab + "\t";
        try {
            System.out.print(" | xP: " + parent.getFather().getX());
        }
        catch (Exception ex) {
            System.out.print(" | xP: 0");
        }
        System.out.print(" | visible: " + parent.isVisible());
        try {
            System.out.print(" | father: " + parent.getFather().getId());
        }
        catch (Exception ex) {
            System.out.print(" | father: null");
        }
        System.out.print("\n");
        for (int i = 0; i < parent.size(); ++i) {
            this.printTree((TreeElement)parent.get(i), (String)tab);
        }
    }
}

