/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.tables;

import com.biotechvana.phylograph.utils.FileToString;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class TableAttachment
extends JDialog {
    private static final long serialVersionUID = -8598808562421374542L;
    private DefaultTableModel tableModel = new DefaultTableModel();
    private JTable table = new JTable(this.tableModel);
    private String[] columnNames = new String[]{"OTU", "Attachment"};
    private String[][] data = new String[][]{{"", ""}};
    private FileToString fts = new FileToString();
    private JFrame frame;

    public TableAttachment(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.frame = frame;
        Container cp = this.getContentPane();
        this.setSize(new Dimension(600, 400));
        cp.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane();
        scroll.getViewport().add(this.table);
        this.table.setSelectionMode(0);
        cp.add((Component)scroll, "Center");
        this.tableModel.setDataVector(this.data, this.columnNames);
        this.tableModel.addTableModelListener(new MyTableModelListener(this.table));
    }

    public Object[][] getOtuValues() {
        Object[][] res = new Object[this.tableModel.getRowCount() - 1][this.tableModel.getColumnCount()];
        for (int row = 0; row < this.tableModel.getRowCount() - 1; ++row) {
            for (int col = 0; col < this.tableModel.getColumnCount(); ++col) {
                res[row][col] = this.tableModel.getValueAt(row, col);
            }
        }
        return res;
    }

    public void exportOtu(String prefFile) {
        JFileChooser chooser = new JFileChooser(prefFile);
        chooser.setDialogTitle("Export OTU-Attachment table");
        chooser.setMultiSelectionEnabled(false);
        int sel = chooser.showSaveDialog(this.frame);
        if (sel != 0) {
            return;
        }
        File output = chooser.getSelectedFile();
        Object[][] values = this.getOtuValues();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            sb.append(String.valueOf(values[i][0]) + ";" + String.valueOf(values[i][1]) + "\r\n");
        }
        try {
            FileWriter fw = new FileWriter(output);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(sb.toString());
            bw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String importOtu() throws IOException {
        File input = this.openFileDialog();
        int res = this.readAttachmentFile(input);
        if (input == null || res != 0) {
            return null;
        }
        return input.getAbsolutePath();
    }

    public String importOtu(String fileName) throws IOException {
        File input = new File(fileName);
        if (!input.exists()) {
            return null;
        }
        this.readAttachmentFile(input);
        return input.getAbsolutePath();
    }

    private File openFileDialog() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Import OTU-Attachment table");
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        int sel = chooser.showOpenDialog(this.frame);
        if (sel != 0) {
            return null;
        }
        File input = chooser.getSelectedFile();
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readAttachmentFile(File file) throws IOException {
        HashMap<String, String> mapData = new HashMap<String, String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.charAt(0) == '#') continue;
                String[] parts = line.split(";");
                String value = "";
                if (parts.length == 2) {
                    value = parts[1].trim();
                }
                mapData.put(parts[0], value);
            }
        }
        Object[][] otulist = new Object[mapData.size() + 1][2];
        int i = 0;
        for (String key : mapData.keySet()) {
            otulist[i][0] = key;
            otulist[i][1] = mapData.get(key);
            ++i;
        }
        otulist[otulist.length - 1][0] = "";
        otulist[otulist.length - 1][1] = "";
        this.tableModel.setDataVector(otulist, this.columnNames);
        return 0;
    }

    public class MyTableModelListener
    implements TableModelListener {
        JTable table;

        public MyTableModelListener(JTable table) {
            this.table = table;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            int firstRow = e.getFirstRow();
            int lastRow = e.getLastRow();
            int mColIndex = e.getColumn();
            switch (e.getType()) {
                case 1: {
                    for (int r = firstRow; r <= lastRow; ++r) {
                    }
                    break;
                }
                case 0: {
                    if (firstRow == -1) {
                        if (mColIndex != -1) break;
                        break;
                    }
                    for (int r = firstRow; r <= lastRow; ++r) {
                        if (r == this.table.getRowCount() - 1) {
                            Object value0 = this.table.getValueAt(r, 0);
                            Object value1 = this.table.getValueAt(r, 1);
                            if (value0.toString().length() > 0 && value1.toString().length() > 0) {
                                TableAttachment.this.tableModel.addRow(new Object[]{"", ""});
                            }
                        }
                        if (mColIndex != -1) continue;
                    }
                    break;
                }
                case -1: {
                    for (int r = firstRow; r <= lastRow; ++r) {
                    }
                    break;
                }
            }
        }
    }
}

