/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.project;

import com.biotechvana.phylograph.InternalF;
import com.biotechvana.phylograph.TreeElement;
import com.biotechvana.phylograph.components.Node;
import com.biotechvana.phylograph.components.Otu;
import com.biotechvana.phylograph.components.Scale;
import com.biotechvana.phylograph.xml.Components2XML;
import com.biotechvana.phylograph.xml.TreeList2Xml;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class ProjectSaver {
    private TreeElement treeList;
    private Otu[] otuArray;
    private Node[] nodeArray;
    private List<?> textLabelList;
    private List<?> bracketList;
    private Scale scale;
    private String treeView;
    private boolean inverted;
    private boolean showBootstrap;
    private boolean showAttachment;
    private boolean showUrl;
    private boolean showClusters;
    private double minBootstrap;
    private String attachmentFileName;
    private int attachmentDistance;
    private String urlFileName;
    private String clusterFileName;
    private double scaleFactorX;
    private double scaleFactorY;
    private double scaleInc;
    private int marginX;
    private int marginY;
    private Font fontOtu;
    private Font fontOtuLink;
    private Font fontLabel;
    private Font fontBootstrap;
    private Font fontAttachment;
    private Font fontCluster;
    private Color colorOtu;
    private Color colorOtuLink;
    private Color colorLabel;
    private Color colorBootstrap;
    private Color colorAttachment;
    private Color colorCluster;
    private File fileProject;
    private File fileTree;
    private File fileComponents;

    public void save(File output, InternalF internalF) {
        this.treeList = internalF.getTreeList();
        this.otuArray = internalF.getOtuArray();
        this.nodeArray = internalF.getNodeArray();
        this.textLabelList = internalF.getLabelList();
        this.bracketList = internalF.getBracketList();
        this.scale = internalF.getScale();
        this.treeView = internalF.getTreeView();
        this.inverted = internalF.isInverted();
        this.showBootstrap = internalF.showBootstrap();
        this.minBootstrap = internalF.getMinBootstrap();
        this.showAttachment = internalF.isShowAttachment();
        this.attachmentFileName = internalF.getAttachmentFileName();
        this.attachmentDistance = internalF.getAttachmentDistance();
        this.urlFileName = internalF.getUrlFileName();
        this.showUrl = internalF.isShowLink();
        this.showClusters = internalF.isShowClusters();
        this.clusterFileName = internalF.getClusterFileName();
        this.scaleFactorX = internalF.getScaleFactorX();
        this.scaleFactorY = internalF.getScaleFactorY();
        this.scaleInc = internalF.getScaleInc();
        this.marginX = internalF.getMarginX();
        this.marginY = internalF.getMarginY();
        this.fontOtu = internalF.fontArray[0];
        this.fontOtuLink = internalF.fontArray[1];
        this.fontLabel = internalF.fontArray[2];
        this.fontBootstrap = internalF.fontArray[3];
        this.fontAttachment = internalF.fontArray[4];
        this.fontCluster = internalF.fontArray[5];
        this.colorOtu = internalF.colorArray[0];
        this.colorOtuLink = internalF.colorArray[1];
        this.colorLabel = internalF.colorArray[2];
        this.colorBootstrap = internalF.colorArray[3];
        this.colorAttachment = internalF.colorArray[4];
        this.colorCluster = internalF.colorArray[5];
        String complete = output.getAbsolutePath();
        String name = complete.substring(complete.lastIndexOf("\\") + 1);
        String path = complete.substring(0, complete.lastIndexOf("\\"));
        if (name.endsWith(".phylo")) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        this.fileProject = new File(path + "/" + name + ".phylo");
        this.fileTree = new File(path + "/" + name + "_tree.xml");
        this.fileComponents = new File(path + "/" + name + "_components.xml");
        this.savePhyloFile();
        this.saveTreeList();
        this.saveComponents();
    }

    private void savePhyloFile() {
        try {
            FileWriter fr = new FileWriter(this.fileProject);
            BufferedWriter bw = new BufferedWriter(fr);
            bw.write("tree=" + this.fileTree.toString());
            bw.write("\n");
            bw.write("components=" + this.fileComponents.toString());
            bw.write("\n");
            bw.write("treeType=" + this.treeView);
            bw.write("\n");
            bw.write("inverted=" + String.valueOf(this.inverted));
            bw.write("\n");
            bw.write("bootstrap=" + String.valueOf(this.showBootstrap));
            bw.write("\n");
            bw.write("bootstrapMinValue=" + String.valueOf(this.minBootstrap));
            bw.write("\n");
            bw.write("attachment=" + String.valueOf(this.showAttachment));
            bw.write("\n");
            bw.write("attachmentFile=" + this.attachmentFileName);
            bw.write("\n");
            bw.write("attachmentDistance=" + String.valueOf(this.attachmentDistance));
            bw.write("\n");
            bw.write("url=" + String.valueOf(this.showUrl));
            bw.write("\n");
            bw.write("urlFile=" + String.valueOf(this.urlFileName));
            bw.write("\n");
            bw.write("cluster=" + String.valueOf(this.showClusters));
            bw.write("\n");
            bw.write("clusterFile=" + this.clusterFileName);
            bw.write("\n");
            bw.write("scaleFactorX=" + this.scaleFactorX);
            bw.write("\n");
            bw.write("scaleFactorY=" + this.scaleFactorY);
            bw.write("\n");
            bw.write("scaleInc=" + this.scaleInc);
            bw.write("\n");
            bw.write("marginX=" + this.marginX);
            bw.write("\n");
            bw.write("marginY=" + this.marginY);
            bw.write("\n");
            bw.write("fontOtu=" + String.valueOf(this.fontOtu));
            bw.write("\n");
            bw.write("fontOtuLink=" + String.valueOf(this.fontOtuLink));
            bw.write("\n");
            bw.write("fontLabel=" + String.valueOf(this.fontLabel));
            bw.write("\n");
            bw.write("fontBootstrap=" + String.valueOf(this.fontBootstrap));
            bw.write("\n");
            bw.write("fontAttachment=" + String.valueOf(this.fontAttachment));
            bw.write("\n");
            bw.write("fontCluster=" + String.valueOf(this.fontCluster));
            bw.write("\n");
            bw.write("colorOtu=" + String.valueOf(this.colorOtu));
            bw.write("\n");
            bw.write("colorOtuLink=" + String.valueOf(this.colorOtuLink));
            bw.write("\n");
            bw.write("colorLabel=" + String.valueOf(this.colorLabel));
            bw.write("\n");
            bw.write("colorBootstrap=" + String.valueOf(this.colorBootstrap));
            bw.write("\n");
            bw.write("colorAttachment=" + String.valueOf(this.colorAttachment));
            bw.write("\n");
            bw.write("colorCluster=" + String.valueOf(this.colorCluster));
            bw.close();
            fr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveTreeList() {
        TreeList2Xml t2x = new TreeList2Xml();
        t2x.createXmlFile(this.treeList, this.fileTree, this.otuArray, this.nodeArray);
    }

    private void saveComponents() {
        Components2XML components2XML = new Components2XML();
        components2XML.createXmlFile(this.fileComponents, this.textLabelList, this.bracketList, this.scale);
    }
}

