/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.internalf;

import com.biotechvana.phylograph.InternalF;
import com.biotechvana.phylograph.TreeElement;
import com.biotechvana.phylograph.components.Bootstrap;
import com.biotechvana.phylograph.components.Node;
import com.biotechvana.phylograph.components.Otu;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Iterator;

public class ComponentsManager {
    double scaleFactorX = 0.0;
    double scaleFactorY = 0.0;
    int marginX = 0;
    int marginY = 0;
    Node[] nodeArray;
    Otu[] otuArray;
    Bootstrap[] bootArray;

    public void createElements(InternalF internalF) {
        int i;
        this.nodeArray = internalF.getNodeArray();
        this.otuArray = internalF.getOtuArray();
        this.bootArray = internalF.getBootArray();
        this.scaleFactorX = internalF.getScaleFactorX();
        this.scaleFactorY = internalF.getScaleFactorY();
        this.marginX = internalF.getMarginX();
        this.marginY = internalF.getMarginY();
        if (this.nodeArray != null) {
            for (i = 0; i < this.nodeArray.length; ++i) {
                try {
                    internalF.getPanelTree().remove(this.nodeArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.nodeArray = null;
        this.nodeArray = new Node[internalF.getTreeUtils().getNumNode(internalF.getTreeList())];
        if (this.otuArray != null) {
            for (i = 0; i < this.otuArray.length; ++i) {
                try {
                    internalF.getPanelTree().remove(this.otuArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.otuArray = null;
        this.otuArray = new Otu[internalF.getTreeUtils().getNumOtu(internalF.getTreeList())];
        this.createTreeElements(internalF, internalF.getTreeList(), null);
        if (this.bootArray != null) {
            for (i = 0; i < this.bootArray.length; ++i) {
                try {
                    internalF.getPanelTree().remove(this.bootArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.bootArray = new Bootstrap[internalF.getTreeUtils().getNumNode(internalF.getTreeList())];
        this.createBootstrap(internalF, internalF.getTreeList());
        internalF.getPanelTree().repaint();
    }

    private void createTreeElements(InternalF internalF, TreeElement parent, Node father) {
        int id;
        if (parent.isNode()) {
            id = parent.getId();
            int level = parent.getLevel();
            int x = (int)Math.round(parent.getX() * this.scaleFactorX) + this.marginX - 3;
            int y = (int)Math.round(parent.getY() * this.scaleFactorY) + this.marginY - 3;
            this.nodeArray[id] = new Node(internalF, id, level, 0, 0);
            this.nodeArray[id].setRoot(parent.isRoot());
            this.nodeArray[id].setBounds(x, y, 8, 8);
            this.nodeArray[id].setFather(father);
            this.nodeArray[id].setLength(parent.getLength());
            this.nodeArray[id].setBootstrap(parent.getBootstrap());
            this.nodeArray[id].setTreeX(parent.getX());
            this.nodeArray[id].setTreeY(parent.getY());
            father = this.nodeArray[id];
            internalF.getPanelTree().add(this.nodeArray[id]);
        } else {
            id = parent.getId();
            String text = parent.getText();
            int level = parent.getLevel();
            double length = parent.getLength();
            double x = parent.getX();
            double y = parent.getY();
            Color colorText = parent.getColorText();
            Font font = parent.getFont();
            if (font == null) {
                font = internalF.getFonts()[0];
            }
            FontMetrics fMetrics = internalF.getFontMetrics(font);
            this.otuArray[id] = new Otu(internalF, id, text, level);
            this.otuArray[id].setBounds((int)Math.round(x * this.scaleFactorX) + this.marginX, (int)Math.round(y * this.scaleFactorY) + this.marginY - fMetrics.getHeight() / 2, fMetrics.stringWidth(text), fMetrics.getHeight());
            this.otuArray[id].setFather(father);
            this.otuArray[id].setTreeX(x);
            this.otuArray[id].setTreeY(y);
            this.otuArray[id].setLength(length);
            this.otuArray[id].setForeground(colorText);
            this.otuArray[id].setFont(font);
            internalF.getPanelTree().add(this.otuArray[id]);
        }
        Iterator iter = parent.iterator();
        while (iter.hasNext()) {
            this.createTreeElements(internalF, (TreeElement)iter.next(), father);
        }
    }

    private void createBootstrap(InternalF internalF, TreeElement parent) {
        if (parent.isNode()) {
            try {
                Font font;
                int id = parent.getId();
                try {
                    font = this.bootArray[id].getFont();
                }
                catch (Exception ex) {
                    font = internalF.getFonts()[3];
                }
                FontMetrics fontMetrics = internalF.getFontMetrics(font);
                double boot = parent.getBootstrap();
                int x = this.nodeArray[id].getX();
                int y = this.nodeArray[id].getY() - fontMetrics.getHeight() / 2 + 3;
                this.bootArray[id] = new Bootstrap(internalF, id, boot, x + 6, y);
                this.nodeArray[id].setBootPos(x + 6, y);
                internalF.getPanelTree().add(this.bootArray[id]);
                if (internalF.showBootstrap() && boot > internalF.getMinBootstrap()) {
                    this.bootArray[id].setVisible(true);
                } else {
                    this.bootArray[id].setVisible(false);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.createBootstrap(internalF, (TreeElement)parent.get(i));
        }
    }
}

