/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class FontDialogOtu
extends JDialog {
    private static final long serialVersionUID = 7342635254852750586L;
    private static final String[] family = new String[]{"Arial", "Courier", "Georgia", "Helvetica", "Monospaced", "Serif", "SansSerif", "Times New Roman"};
    private static final String[] size = new String[]{"6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "28", "34", "40"};
    private static final String[] style = new String[]{"Plain", "Bold", "Italic", "Italic+Bold"};
    private Font font;
    private Color colorText;
    private Border borderButtons = BorderFactory.createLineBorder(Color.BLACK, 1);
    private JLabel labelFamily;
    private JLabel labelSize;
    private JLabel labelStyle;
    private JComboBox<?> comboFamily;
    private JComboBox<?> comboSize;
    private JComboBox<?> comboStyle;
    private JButton buttonTextColor;
    private JLabel labelTextColor;
    private JLabel labelPreview;
    private JButton buttonOK;

    public FontDialogOtu(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        this.initComponents();
        this.addListeners();
        cp.add((Component)this.createPanel(), "Center");
        this.pack();
    }

    private void initComponents() {
        this.font = new Font("SansSeriff", 0, 12);
        this.labelFamily = new JLabel("Family");
        this.labelSize = new JLabel("Size");
        this.labelStyle = new JLabel("Style");
        this.comboFamily = new JComboBox<String>(family);
        this.comboSize = new JComboBox<String>(size);
        this.comboStyle = new JComboBox<String>(style);
        this.buttonTextColor = new JButton("Text color");
        this.labelTextColor = new JLabel("     ");
        this.labelPreview = new JLabel("  Preview  ");
        this.buttonOK = new JButton("OK");
        this.colorText = Color.BLACK;
        this.labelTextColor.setSize(20, 20);
        this.labelTextColor.setOpaque(true);
        this.labelTextColor.setBackground(this.colorText);
        this.labelTextColor.setBorder(this.borderButtons);
        this.labelPreview.setFont(this.font);
        this.labelPreview.setOpaque(true);
        this.labelPreview.setForeground(this.colorText);
        this.labelPreview.setBackground(Color.WHITE);
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel();
        JPanel panelFont = new JPanel();
        JPanel panelColor = new JPanel();
        JPanel panelPreview = new JPanel();
        JPanel panelOk = new JPanel();
        Border borderBase = BorderFactory.createEtchedBorder();
        panel.setLayout(new BoxLayout(panel, 1));
        panelFont.setLayout(new FlowLayout(1));
        panelFont.add(this.labelFamily);
        panelFont.add(this.comboFamily);
        panelFont.add(this.labelSize);
        panelFont.add(this.comboSize);
        panelFont.add(this.labelStyle);
        panelFont.add(this.comboStyle);
        panelFont.setBorder(BorderFactory.createTitledBorder(borderBase, "Font"));
        panelColor.setLayout(new FlowLayout(1));
        panelColor.add(this.buttonTextColor);
        panelColor.add(this.labelTextColor);
        panelColor.setBorder(BorderFactory.createTitledBorder(borderBase, "Color"));
        panelPreview.setLayout(new FlowLayout(1));
        panelPreview.add(this.labelPreview);
        panelPreview.setBackground(Color.WHITE);
        panelOk.setLayout(new FlowLayout(1));
        panelOk.add(this.buttonOK);
        panelOk.setBorder(borderBase);
        panel.add(panelFont);
        panel.add(panelColor);
        panel.add(panelOk);
        return panel;
    }

    private void addListeners() {
        this.comboFamily.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JComboBox combo = (JComboBox)ae.getSource();
                String sel = combo.getSelectedItem().toString();
                FontDialogOtu.this.font = new Font(sel, FontDialogOtu.this.font.getStyle(), FontDialogOtu.this.font.getSize());
                FontDialogOtu.this.updatePreview();
            }
        });
        this.comboSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JComboBox combo = (JComboBox)ae.getSource();
                int sel = Integer.parseInt(combo.getSelectedItem().toString());
                FontDialogOtu.this.font = new Font(FontDialogOtu.this.font.getFamily(), FontDialogOtu.this.font.getStyle(), sel);
                FontDialogOtu.this.updatePreview();
            }
        });
        this.comboStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JComboBox combo = (JComboBox)ae.getSource();
                String sel = combo.getSelectedItem().toString();
                int style = 0;
                if (sel.equalsIgnoreCase("plain")) {
                    style = 0;
                } else if (sel.equalsIgnoreCase("bold")) {
                    style = 1;
                } else if (sel.equalsIgnoreCase("italic")) {
                    style = 2;
                } else if (sel.equalsIgnoreCase("italic+bold")) {
                    style = 3;
                }
                FontDialogOtu.this.font = new Font(FontDialogOtu.this.font.getFamily(), style, FontDialogOtu.this.font.getSize());
                FontDialogOtu.this.updatePreview();
            }
        });
        this.buttonTextColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Color sel;
                FontDialogOtu.this.colorText = sel = JColorChooser.showDialog(null, "Choose", Color.BLACK);
                FontDialogOtu.this.labelTextColor.setBackground(sel);
                FontDialogOtu.this.updatePreview();
            }
        });
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FontDialogOtu.this.setVisible(false);
            }
        });
    }

    public void showDialog(Font font, Color text) {
        int i;
        this.font = font;
        String family = font.getFamily();
        for (i = 0; i < this.comboFamily.getItemCount(); ++i) {
            if (this.comboFamily.getItemAt(i).toString().compareToIgnoreCase(family) != 0) continue;
            this.comboFamily.setSelectedIndex(i);
        }
        int size = font.getSize();
        for (i = 0; i < this.comboSize.getItemCount(); ++i) {
            if (Integer.parseInt(this.comboSize.getItemAt(i).toString()) != size) continue;
            this.comboSize.setSelectedIndex(i);
        }
        int style = font.getStyle();
        String style2 = "plain";
        switch (style) {
            case 0: {
                style2 = "plain";
                break;
            }
            case 1: {
                style2 = "bold";
                break;
            }
            case 2: {
                style2 = "italic";
                break;
            }
            case 3: {
                style2 = "italic+bold";
            }
        }
        for (i = 0; i < this.comboStyle.getItemCount(); ++i) {
            if (!this.comboStyle.getItemAt(i).toString().equalsIgnoreCase(style2)) continue;
            this.comboStyle.setSelectedIndex(i);
        }
        this.colorText = text;
        this.labelTextColor.setBackground(this.colorText);
        this.updatePreview();
        this.setVisible(true);
    }

    private void updatePreview() {
        this.labelPreview.setFont(this.font);
        this.labelPreview.setForeground(this.colorText);
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    public Color getTextColor() {
        return this.colorText;
    }
}

