/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FontDialog
extends JDialog {
    private static final long serialVersionUID = 5324190739232392987L;
    private static final String[] family = new String[]{"Arial", "Courier", "Georgia", "Helvetica", "Monospaced", "Serif", "SansSerif", "Times New Roman"};
    private JLabel labelOtu;
    private JLabel labelOtuLink;
    private JLabel labelLabel;
    private JLabel labelBootstrap;
    private JLabel labelHost;
    private JLabel labelCluster;
    private JLabel labelPreview;
    private JLabel labelType;
    private JLabel labelSize;
    private JLabel labelFamily;
    private JLabel labelColor;
    private JLabel labelOtuTest;
    private JLabel labelOtuLinkTest;
    private JLabel labelLabelTest;
    private JLabel labelBootstrapTest;
    private JLabel labelHostTest;
    private JLabel labelClusterTest;
    private JComboBox<?> comboOtuType;
    private JComboBox<?> comboOtuLinkType;
    private JComboBox<?> comboLabelType;
    private JComboBox<?> comboBootstrapType;
    private JComboBox<?> comboHostType;
    private JComboBox<?> comboClusterType;
    private JComboBox<?> comboOtuSize;
    private JComboBox<?> comboOtuLinkSize;
    private JComboBox<?> comboLabelSize;
    private JComboBox<?> comboBootstrapSize;
    private JComboBox<?> comboHostSize;
    private JComboBox<?> comboClusterSize;
    private JComboBox<?> comboOtuFamily;
    private JComboBox<?> comboOtuLinkFamily;
    private JComboBox<?> comboLabelFamily;
    private JComboBox<?> comboBootstrapFamily;
    private JComboBox<?> comboHostFamily;
    private JComboBox<?> comboClusterFamily;
    private String[] type;
    private String[] size;
    private Font fontOtu;
    private Font fontOtuLink;
    private Font fontLabel;
    private Font fontBootstrap;
    private Font fontHost;
    private Font fontCluster;
    private Color colorOtu;
    private Color colorOtuLink;
    private Color colorLabel;
    private Color colorBootstrap;
    private Color colorHost;
    private Color colorCluster;
    private ColorButton cbuttonOtu;
    private ColorButton cbuttonOtuLink;
    private ColorButton cbuttonLabel;
    private ColorButton cbuttonBootstrap;
    private ColorButton cbuttonHost;
    private ColorButton cbuttonCluster;
    private JButton buttonApply;

    public FontDialog(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        Container cp = this.getContentPane();
        this.initComponents();
        cp.setLayout(new BorderLayout());
        cp.add((Component)this.createPanelCombo(), "Center");
        cp.add((Component)new JLabel("  "), "South");
        this.addListeners();
        this.setResizable(false);
        this.pack();
    }

    public void initComponents() {
        this.fontOtu = new Font("SansSerif", 0, 12);
        this.fontOtuLink = new Font("SansSerif", 0, 12);
        this.fontLabel = new Font("SansSerif", 1, 12);
        this.fontBootstrap = new Font("SansSerif", 0, 10);
        this.fontHost = new Font("SansSerif", 2, 12);
        this.fontCluster = new Font("SansSerif", 0, 12);
        this.colorOtu = Color.BLACK;
        this.colorOtuLink = Color.BLUE;
        this.colorLabel = Color.BLACK;
        this.colorBootstrap = Color.BLACK;
        this.colorHost = Color.BLACK;
        this.colorCluster = Color.BLACK;
        this.type = new String[]{"Normal", "Bold", "Italic", "Bold+Italic"};
        this.size = new String[]{"6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "28", "34", "40"};
        this.labelOtuTest = new JLabel("OTU");
        this.labelOtuLinkTest = new JLabel("OTU link");
        this.labelLabelTest = new JLabel("Label");
        this.labelBootstrapTest = new JLabel("Bootstrap");
        this.labelHostTest = new JLabel("Attachment");
        this.labelClusterTest = new JLabel("Cluster");
        this.labelOtuTest.setHorizontalAlignment(0);
        this.labelOtuLinkTest.setHorizontalAlignment(0);
        this.labelLabelTest.setHorizontalAlignment(0);
        this.labelBootstrapTest.setHorizontalAlignment(0);
        this.labelHostTest.setHorizontalAlignment(0);
        this.labelClusterTest.setHorizontalAlignment(0);
        this.labelOtuTest.setFont(this.fontOtu);
        this.labelOtuLinkTest.setFont(this.fontOtuLink);
        this.labelLabelTest.setFont(this.fontLabel);
        this.labelBootstrapTest.setFont(this.fontBootstrap);
        this.labelHostTest.setFont(this.fontHost);
        this.labelClusterTest.setFont(this.fontCluster);
        this.labelOtuTest.setOpaque(true);
        this.labelOtuLinkTest.setOpaque(true);
        this.labelLabelTest.setOpaque(true);
        this.labelBootstrapTest.setOpaque(true);
        this.labelHostTest.setOpaque(true);
        this.labelClusterTest.setOpaque(true);
        this.labelOtuTest.setBackground(Color.WHITE);
        this.labelOtuLinkTest.setBackground(Color.WHITE);
        this.labelLabelTest.setBackground(Color.WHITE);
        this.labelBootstrapTest.setBackground(Color.WHITE);
        this.labelHostTest.setBackground(Color.WHITE);
        this.labelClusterTest.setBackground(Color.WHITE);
        this.labelOtuTest.setForeground(Color.BLACK);
        this.labelOtuLinkTest.setForeground(Color.BLUE);
        this.labelLabelTest.setForeground(Color.BLACK);
        this.labelBootstrapTest.setForeground(Color.BLACK);
        this.labelHostTest.setForeground(Color.BLACK);
        this.labelClusterTest.setForeground(Color.BLACK);
        this.labelOtu = new JLabel("  OTU: ");
        this.labelOtuLink = new JLabel("  OTU link: ");
        this.labelLabel = new JLabel("  Label: ");
        this.labelBootstrap = new JLabel("  Bootstrap: ");
        this.labelHost = new JLabel("  Attachment: ");
        this.labelCluster = new JLabel("  Cluster: ");
        this.labelType = new JLabel("Type");
        this.labelSize = new JLabel("Size");
        this.labelFamily = new JLabel("Family");
        this.labelColor = new JLabel("Color");
        this.labelPreview = new JLabel("Preview");
        this.labelType.setHorizontalAlignment(0);
        this.labelSize.setHorizontalAlignment(0);
        this.labelFamily.setHorizontalAlignment(0);
        this.labelColor.setHorizontalAlignment(0);
        this.labelPreview.setHorizontalAlignment(0);
        this.comboOtuType = new JComboBox<String>(this.type);
        this.comboOtuSize = new JComboBox<String>(this.size);
        this.comboOtuFamily = new JComboBox<String>(family);
        this.comboOtuType.setActionCommand("taxa_type");
        this.comboOtuSize.setActionCommand("taxa_size");
        this.comboOtuFamily.setActionCommand("taxa_family");
        this.comboOtuType.setSelectedIndex(0);
        this.comboOtuSize.setSelectedIndex(2);
        this.comboOtuFamily.setSelectedIndex(2);
        this.comboOtuLinkType = new JComboBox<String>(this.type);
        this.comboOtuLinkSize = new JComboBox<String>(this.size);
        this.comboOtuLinkFamily = new JComboBox<String>(family);
        this.comboOtuLinkType.setActionCommand("taxalink_type");
        this.comboOtuLinkSize.setActionCommand("taxalink_size");
        this.comboOtuLinkFamily.setActionCommand("taxalink_family");
        this.comboOtuLinkType.setSelectedIndex(0);
        this.comboOtuLinkSize.setSelectedIndex(2);
        this.comboOtuLinkFamily.setSelectedIndex(2);
        this.comboLabelType = new JComboBox<String>(this.type);
        this.comboLabelSize = new JComboBox<String>(this.size);
        this.comboLabelFamily = new JComboBox<String>(family);
        this.comboLabelType.setActionCommand("label_type");
        this.comboLabelSize.setActionCommand("label_size");
        this.comboLabelFamily.setActionCommand("label_family");
        this.comboLabelType.setSelectedIndex(1);
        this.comboLabelSize.setSelectedIndex(2);
        this.comboLabelFamily.setSelectedIndex(2);
        this.comboBootstrapType = new JComboBox<String>(this.type);
        this.comboBootstrapSize = new JComboBox<String>(this.size);
        this.comboBootstrapFamily = new JComboBox<String>(family);
        this.comboBootstrapType.setActionCommand("bootstrap_type");
        this.comboBootstrapSize.setActionCommand("bootstrap_size");
        this.comboBootstrapFamily.setActionCommand("bootstrap_family");
        this.comboBootstrapType.setSelectedIndex(0);
        this.comboBootstrapSize.setSelectedIndex(1);
        this.comboBootstrapFamily.setSelectedIndex(2);
        this.comboHostType = new JComboBox<String>(this.type);
        this.comboHostSize = new JComboBox<String>(this.size);
        this.comboHostFamily = new JComboBox<String>(family);
        this.comboHostType.setActionCommand("host_type");
        this.comboHostSize.setActionCommand("host_size");
        this.comboHostFamily.setActionCommand("host_family");
        this.comboHostType.setSelectedIndex(2);
        this.comboHostSize.setSelectedIndex(2);
        this.comboHostFamily.setSelectedIndex(2);
        this.comboClusterType = new JComboBox<String>(this.type);
        this.comboClusterSize = new JComboBox<String>(this.size);
        this.comboClusterFamily = new JComboBox<String>(family);
        this.comboClusterType.setActionCommand("cluster_type");
        this.comboClusterSize.setActionCommand("cluster_size");
        this.comboClusterFamily.setActionCommand("cluster_family");
        this.comboClusterType.setSelectedIndex(2);
        this.comboClusterSize.setSelectedIndex(2);
        this.comboClusterFamily.setSelectedIndex(2);
        this.cbuttonOtu = new ColorButton(this.colorOtu);
        this.cbuttonOtuLink = new ColorButton(this.colorOtuLink);
        this.cbuttonLabel = new ColorButton(this.colorLabel);
        this.cbuttonBootstrap = new ColorButton(this.colorBootstrap);
        this.cbuttonHost = new ColorButton(this.colorHost);
        this.cbuttonCluster = new ColorButton(this.colorCluster);
        this.cbuttonOtu.setActionCommand("taxa_color");
        this.cbuttonOtuLink.setActionCommand("taxalink_color");
        this.cbuttonLabel.setActionCommand("label_color");
        this.cbuttonBootstrap.setActionCommand("bootstrap_color");
        this.cbuttonHost.setActionCommand("host_color");
        this.cbuttonCluster.setActionCommand("cluster_color");
        this.buttonApply = new JButton("Apply");
        this.buttonApply.addActionListener(new ApplyListener());
    }

    private void addListeners() {
        TypeListener tl = new TypeListener();
        this.comboOtuType.addActionListener(tl);
        this.comboOtuLinkType.addActionListener(tl);
        this.comboLabelType.addActionListener(tl);
        this.comboBootstrapType.addActionListener(tl);
        this.comboHostType.addActionListener(tl);
        this.comboClusterType.addActionListener(tl);
        SizeListener sl = new SizeListener();
        this.comboOtuSize.addActionListener(sl);
        this.comboOtuLinkSize.addActionListener(sl);
        this.comboLabelSize.addActionListener(sl);
        this.comboBootstrapSize.addActionListener(sl);
        this.comboHostSize.addActionListener(sl);
        this.comboClusterSize.addActionListener(sl);
        FamilyListener fl = new FamilyListener();
        this.comboOtuFamily.addActionListener(fl);
        this.comboOtuLinkFamily.addActionListener(fl);
        this.comboLabelFamily.addActionListener(fl);
        this.comboBootstrapFamily.addActionListener(fl);
        this.comboHostFamily.addActionListener(fl);
        this.comboClusterFamily.addActionListener(fl);
        ColorListener colorlistener = new ColorListener();
        this.cbuttonOtu.addActionListener(colorlistener);
        this.cbuttonOtuLink.addActionListener(colorlistener);
        this.cbuttonLabel.addActionListener(colorlistener);
        this.cbuttonBootstrap.addActionListener(colorlistener);
        this.cbuttonHost.addActionListener(colorlistener);
        this.cbuttonCluster.addActionListener(colorlistener);
    }

    private JPanel createPanelCombo() {
        JPanel panel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(panel, 1);
        panel.setLayout(boxLayout);
        JPanel panelOtu = new JPanel();
        panelOtu.setLayout(new FlowLayout(0));
        panelOtu.add(this.labelOtu);
        panelOtu.add(this.comboOtuType);
        panelOtu.add(this.comboOtuSize);
        panelOtu.add(this.comboOtuFamily);
        panelOtu.add(this.cbuttonOtu);
        panelOtu.add(this.labelOtuTest);
        JPanel panelOtuLink = new JPanel();
        panelOtuLink.setLayout(new FlowLayout(0));
        panelOtuLink.add(this.labelOtuLink);
        panelOtuLink.add(this.comboOtuLinkType);
        panelOtuLink.add(this.comboOtuLinkSize);
        panelOtuLink.add(this.comboOtuLinkFamily);
        panelOtuLink.add(this.cbuttonOtuLink);
        panelOtuLink.add(this.labelOtuLinkTest);
        this.comboOtuLinkType.setEnabled(false);
        this.comboOtuLinkSize.setEnabled(false);
        this.comboOtuLinkFamily.setEnabled(false);
        JPanel panelLabel = new JPanel();
        panelLabel.setLayout(new FlowLayout(0));
        panelLabel.add(this.labelLabel);
        panelLabel.add(this.comboLabelType);
        panelLabel.add(this.comboLabelSize);
        panelLabel.add(this.comboLabelFamily);
        panelLabel.add(this.cbuttonLabel);
        panelLabel.add(this.labelLabelTest);
        JPanel panelBootstrap = new JPanel();
        panelBootstrap.setLayout(new FlowLayout(0));
        panelBootstrap.add(this.labelBootstrap);
        panelBootstrap.add(this.comboBootstrapType);
        panelBootstrap.add(this.comboBootstrapSize);
        panelBootstrap.add(this.comboBootstrapFamily);
        panelBootstrap.add(this.cbuttonBootstrap);
        panelBootstrap.add(this.labelBootstrapTest);
        JPanel panelAttachment = new JPanel();
        panelAttachment.setLayout(new FlowLayout(0));
        panelAttachment.add(this.labelHost);
        panelAttachment.add(this.comboHostType);
        panelAttachment.add(this.comboHostSize);
        panelAttachment.add(this.comboHostFamily);
        panelAttachment.add(this.cbuttonHost);
        panelAttachment.add(this.labelHostTest);
        JPanel panelCluster = new JPanel();
        panelCluster.setLayout(new FlowLayout(0));
        panelCluster.add(this.labelCluster);
        panelCluster.add(this.comboClusterType);
        panelCluster.add(this.comboClusterSize);
        panelCluster.add(this.comboClusterFamily);
        panelCluster.add(this.cbuttonCluster);
        panelCluster.add(this.labelClusterTest);
        JPanel panelApply = new JPanel();
        panelApply.setLayout(new FlowLayout(1));
        panelApply.add(this.buttonApply);
        this.labelOtu.setPreferredSize(new Dimension(80, 20));
        this.labelOtuLink.setPreferredSize(new Dimension(80, 20));
        this.labelLabel.setPreferredSize(new Dimension(80, 20));
        this.labelBootstrap.setPreferredSize(new Dimension(80, 20));
        this.labelHost.setPreferredSize(new Dimension(80, 20));
        this.labelCluster.setPreferredSize(new Dimension(80, 20));
        this.labelOtuTest.setPreferredSize(new Dimension(140, 20));
        this.labelOtuLinkTest.setPreferredSize(new Dimension(140, 20));
        this.labelLabelTest.setPreferredSize(new Dimension(140, 20));
        this.labelBootstrapTest.setPreferredSize(new Dimension(140, 20));
        this.labelHostTest.setPreferredSize(new Dimension(140, 20));
        this.labelClusterTest.setPreferredSize(new Dimension(140, 20));
        panel.add(panelOtu);
        panel.add(panelOtuLink);
        panel.add(panelLabel);
        panel.add(panelBootstrap);
        panel.add(panelAttachment);
        panel.add(panelCluster);
        panel.add(panelApply);
        return panel;
    }

    public Font[] getFontArray() {
        Font[] arrayFonts = new Font[]{this.fontOtu, this.fontOtuLink, this.fontLabel, this.fontBootstrap, this.fontHost, this.fontCluster};
        return arrayFonts;
    }

    public Color[] getColorArray() {
        Color[] arrayColors = new Color[]{this.colorOtu, this.colorOtuLink, this.colorLabel, this.colorBootstrap, this.colorHost, this.colorCluster};
        return arrayColors;
    }

    public void setFontArray(Font[] newFontArray) {
        this.fontOtu = newFontArray[0];
        this.fontOtuLink = newFontArray[1];
        this.fontLabel = newFontArray[2];
        this.fontBootstrap = newFontArray[3];
        this.fontHost = newFontArray[4];
        this.fontCluster = newFontArray[5];
        this.labelOtuTest.setFont(this.fontOtu);
        this.labelOtuLinkTest.setFont(this.fontOtuLink);
        this.labelLabelTest.setFont(this.fontLabel);
        this.labelBootstrapTest.setFont(this.fontBootstrap);
        this.labelHostTest.setFont(this.fontHost);
        this.labelClusterTest.setFont(this.fontCluster);
        this.comboOtuType.setSelectedIndex(this.fontOtu.getStyle());
        this.comboOtuLinkType.setSelectedIndex(this.fontOtuLink.getStyle());
        this.comboLabelType.setSelectedIndex(this.fontLabel.getStyle());
        this.comboBootstrapType.setSelectedIndex(this.fontBootstrap.getStyle());
        this.comboHostType.setSelectedIndex(this.fontHost.getStyle());
        this.comboClusterType.setSelectedIndex(this.fontCluster.getStyle());
        this.comboOtuSize.setSelectedIndex(this.getIndexOfSize(this.comboOtuSize, this.fontOtu.getSize()));
        this.comboOtuLinkSize.setSelectedIndex(this.getIndexOfSize(this.comboOtuLinkSize, this.fontOtuLink.getSize()));
        this.comboLabelSize.setSelectedIndex(this.getIndexOfSize(this.comboLabelSize, this.fontLabel.getSize()));
        this.comboBootstrapSize.setSelectedIndex(this.getIndexOfSize(this.comboBootstrapSize, this.fontBootstrap.getSize()));
        this.comboHostSize.setSelectedIndex(this.getIndexOfSize(this.comboHostSize, this.fontHost.getSize()));
        this.comboClusterSize.setSelectedIndex(this.getIndexOfSize(this.comboClusterSize, this.fontCluster.getSize()));
        this.comboOtuFamily.setSelectedIndex(this.getIndexOfFamily(this.comboOtuFamily, this.fontOtu.getFamily()));
        this.comboOtuLinkFamily.setSelectedIndex(this.getIndexOfFamily(this.comboOtuLinkFamily, this.fontOtuLink.getFamily()));
        this.comboLabelFamily.setSelectedIndex(this.getIndexOfFamily(this.comboLabelFamily, this.fontLabel.getFamily()));
        this.comboBootstrapFamily.setSelectedIndex(this.getIndexOfFamily(this.comboBootstrapFamily, this.fontBootstrap.getFamily()));
        this.comboHostFamily.setSelectedIndex(this.getIndexOfFamily(this.comboHostFamily, this.fontHost.getFamily()));
        this.comboClusterFamily.setSelectedIndex(this.getIndexOfFamily(this.comboClusterFamily, this.fontCluster.getFamily()));
    }

    private int getIndexOfFamily(JComboBox<?> combo, String value) {
        for (int i = 0; i < combo.getItemCount(); ++i) {
            if (!combo.getItemAt(i).equals(value)) continue;
            return i;
        }
        return -1;
    }

    private int getIndexOfSize(JComboBox<?> combo, int value) {
        for (int i = 0; i < combo.getItemCount(); ++i) {
            if (!combo.getItemAt(i).equals(String.valueOf(value))) continue;
            return i;
        }
        return -1;
    }

    class ColorButton
    extends JButton {
        private static final long serialVersionUID = -2970121423316062624L;

        public ColorButton(Color colorDef) {
            this.setPreferredSize(new Dimension(20, 20));
            this.setBorderPainted(false);
            this.setFocusable(false);
            this.setBackground(colorDef);
        }
    }

    class ApplyListener
    implements ActionListener {
        ApplyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            FontDialog.this.setVisible(false);
        }
    }

    class TypeListener
    implements ActionListener {
        TypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int style = ((JComboBox)ae.getSource()).getSelectedIndex();
            String origen = ((JComboBox)ae.getSource()).getActionCommand();
            if (origen.startsWith("taxa_")) {
                FontDialog.this.fontOtu = new Font(FontDialog.this.fontOtu.getFamily(), style, FontDialog.this.fontOtu.getSize());
                FontDialog.this.labelOtuTest.setFont(FontDialog.this.fontOtu);
            } else if (origen.startsWith("taxalink_")) {
                FontDialog.this.fontOtuLink = new Font(FontDialog.this.fontOtuLink.getFamily(), style, FontDialog.this.fontOtuLink.getSize());
                FontDialog.this.labelOtuLinkTest.setFont(FontDialog.this.fontOtuLink);
            } else if (origen.startsWith("label_")) {
                FontDialog.this.fontLabel = new Font(FontDialog.this.fontLabel.getFamily(), style, FontDialog.this.fontLabel.getSize());
                FontDialog.this.labelLabelTest.setFont(FontDialog.this.fontLabel);
            } else if (origen.startsWith("bootstrap_")) {
                FontDialog.this.fontBootstrap = new Font(FontDialog.this.fontBootstrap.getFamily(), style, FontDialog.this.fontBootstrap.getSize());
                FontDialog.this.labelBootstrapTest.setFont(FontDialog.this.fontBootstrap);
            } else if (origen.startsWith("host_")) {
                FontDialog.this.fontHost = new Font(FontDialog.this.fontHost.getFamily(), style, FontDialog.this.fontHost.getSize());
                FontDialog.this.labelHostTest.setFont(FontDialog.this.fontHost);
            } else if (origen.startsWith("cluster_")) {
                FontDialog.this.fontCluster = new Font(FontDialog.this.fontCluster.getFamily(), style, FontDialog.this.fontCluster.getSize());
                FontDialog.this.labelClusterTest.setFont(FontDialog.this.fontCluster);
            }
            FontDialog.this.pack();
        }
    }

    class SizeListener
    implements ActionListener {
        SizeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String origen = ((JComboBox)ae.getSource()).getActionCommand();
            int size = Integer.parseInt(((JComboBox)ae.getSource()).getSelectedItem().toString());
            if (origen.startsWith("taxa_")) {
                FontDialog.this.fontOtu = new Font(FontDialog.this.fontOtu.getFamily(), FontDialog.this.fontOtu.getStyle(), size);
                FontDialog.this.labelOtuTest.setFont(FontDialog.this.fontOtu);
            } else if (origen.startsWith("taxalink_")) {
                FontDialog.this.fontOtuLink = new Font(FontDialog.this.fontOtuLink.getFamily(), FontDialog.this.fontOtuLink.getStyle(), size);
                FontDialog.this.labelOtuLinkTest.setFont(FontDialog.this.fontOtuLink);
            } else if (origen.startsWith("label_")) {
                FontDialog.this.fontLabel = new Font(FontDialog.this.fontLabel.getFamily(), FontDialog.this.fontLabel.getStyle(), size);
                FontDialog.this.labelLabelTest.setFont(FontDialog.this.fontLabel);
            } else if (origen.startsWith("bootstrap_")) {
                FontDialog.this.fontBootstrap = new Font(FontDialog.this.fontBootstrap.getFamily(), FontDialog.this.fontBootstrap.getStyle(), size);
                FontDialog.this.labelBootstrapTest.setFont(FontDialog.this.fontBootstrap);
            } else if (origen.startsWith("host_")) {
                FontDialog.this.fontHost = new Font(FontDialog.this.fontHost.getFamily(), FontDialog.this.fontHost.getStyle(), size);
                FontDialog.this.labelHostTest.setFont(FontDialog.this.fontHost);
            } else if (origen.startsWith("cluster_")) {
                FontDialog.this.fontCluster = new Font(FontDialog.this.fontCluster.getFamily(), FontDialog.this.fontCluster.getStyle(), size);
                FontDialog.this.labelClusterTest.setFont(FontDialog.this.fontCluster);
            }
            FontDialog.this.pack();
        }
    }

    class FamilyListener
    implements ActionListener {
        FamilyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String family = ((JComboBox)ae.getSource()).getSelectedItem().toString();
            String origen = ((JComboBox)ae.getSource()).getActionCommand();
            if (origen.startsWith("taxa_")) {
                FontDialog.this.fontOtu = new Font(family, FontDialog.this.fontOtu.getStyle(), FontDialog.this.fontOtu.getSize());
                FontDialog.this.labelOtuTest.setFont(FontDialog.this.fontOtu);
            } else if (origen.startsWith("taxalink_")) {
                FontDialog.this.fontOtuLink = new Font(family, FontDialog.this.fontOtuLink.getStyle(), FontDialog.this.fontOtuLink.getSize());
                FontDialog.this.labelOtuLinkTest.setFont(FontDialog.this.fontOtuLink);
            } else if (origen.startsWith("label_")) {
                FontDialog.this.fontLabel = new Font(family, FontDialog.this.fontLabel.getStyle(), FontDialog.this.fontLabel.getSize());
                FontDialog.this.labelLabelTest.setFont(FontDialog.this.fontLabel);
            } else if (origen.startsWith("bootstrap_")) {
                FontDialog.this.fontBootstrap = new Font(family, FontDialog.this.fontBootstrap.getStyle(), FontDialog.this.fontBootstrap.getSize());
                FontDialog.this.labelBootstrapTest.setFont(FontDialog.this.fontBootstrap);
            } else if (origen.startsWith("host_")) {
                FontDialog.this.fontHost = new Font(family, FontDialog.this.fontHost.getStyle(), FontDialog.this.fontHost.getSize());
                FontDialog.this.labelHostTest.setFont(FontDialog.this.fontHost);
            } else if (origen.startsWith("cluster_")) {
                FontDialog.this.fontCluster = new Font(family, FontDialog.this.fontCluster.getStyle(), FontDialog.this.fontCluster.getSize());
                FontDialog.this.labelClusterTest.setFont(FontDialog.this.fontCluster);
            }
            FontDialog.this.pack();
        }
    }

    class ColorListener
    implements ActionListener {
        ColorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String origen = ((JButton)ae.getSource()).getActionCommand();
            if (origen.startsWith("taxa_")) {
                FontDialog.this.colorOtu = JColorChooser.showDialog(null, "Choose font color", FontDialog.this.colorOtu);
                FontDialog.this.cbuttonOtu.setBackground(FontDialog.this.colorOtu);
                FontDialog.this.labelOtuTest.setForeground(FontDialog.this.colorOtu);
            } else if (origen.startsWith("taxalink_")) {
                FontDialog.this.colorOtuLink = JColorChooser.showDialog(null, "Choose font color", FontDialog.this.colorOtuLink);
                FontDialog.this.cbuttonOtuLink.setBackground(FontDialog.this.colorOtuLink);
                FontDialog.this.labelOtuLinkTest.setForeground(FontDialog.this.colorOtuLink);
            } else if (origen.startsWith("label_")) {
                FontDialog.this.colorLabel = JColorChooser.showDialog(null, "Choose font color", FontDialog.this.colorLabel);
                FontDialog.this.cbuttonLabel.setBackground(FontDialog.this.colorLabel);
                FontDialog.this.labelLabelTest.setForeground(FontDialog.this.colorLabel);
            } else if (origen.startsWith("bootstrap_")) {
                FontDialog.this.colorBootstrap = JColorChooser.showDialog(null, "Choose font color", FontDialog.this.colorBootstrap);
                FontDialog.this.cbuttonBootstrap.setBackground(FontDialog.this.colorBootstrap);
                FontDialog.this.labelBootstrapTest.setForeground(FontDialog.this.colorBootstrap);
            } else if (origen.startsWith("host_")) {
                FontDialog.this.colorHost = JColorChooser.showDialog(null, "Choose font color", FontDialog.this.colorHost);
                FontDialog.this.cbuttonHost.setBackground(FontDialog.this.colorHost);
                FontDialog.this.labelHostTest.setForeground(FontDialog.this.colorHost);
            } else if (origen.startsWith("cluster_")) {
                FontDialog.this.colorCluster = JColorChooser.showDialog(null, "Choose font color", FontDialog.this.colorCluster);
                FontDialog.this.cbuttonCluster.setBackground(FontDialog.this.colorCluster);
                FontDialog.this.labelClusterTest.setForeground(FontDialog.this.colorCluster);
            }
            FontDialog.this.pack();
        }
    }
}

