/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.coords;

import com.biotechvana.phylograph.TreeElement;
import com.biotechvana.phylograph.TreeUtils;
import com.biotechvana.phylograph.utils.ImproveUnrooted;
import com.biotechvana.phylograph.utils.TreePoint;
import java.util.Iterator;

public class Radial {
    private double minX = 0.0;
    private double minY = 0.0;
    private double minLength;
    private double maxY = 0.0;

    public TreeElement getCoords(TreeElement treeList) {
        TreeElement newRoot;
        TreeUtils treeUtils = new TreeUtils();
        if (treeList.size() == 2) {
            newRoot = (TreeElement)treeList.get(1);
            TreeElement firstChild = (TreeElement)treeList.get(0);
            newRoot.add(firstChild);
            firstChild.setFather(newRoot);
        } else {
            newRoot = (TreeElement)treeList.get(treeList.size() - 1);
            TreeElement newNode = new TreeElement(true, 0, 1, Math.abs(newRoot.getLength()), 0.0, null);
            for (int i = 0; i < treeList.size() - 1; ++i) {
                TreeElement child = (TreeElement)treeList.get(i);
                newNode.add(child);
                child.setFather(newNode);
            }
            newRoot.add(newNode);
            newNode.setFather(newRoot);
        }
        newRoot.setRoot(true);
        newRoot.setFather(null);
        newRoot.setX(0.0);
        newRoot.setY(0.0);
        newRoot.setTreePoint(new TreePoint(0.0, 0.0));
        newRoot.setW(Math.PI * 2);
        newRoot.setT(0.0);
        treeUtils.orderTree(newRoot);
        treeUtils.resetFather(newRoot, null);
        treeUtils.resetLevel(newRoot, 0);
        treeUtils.resetId(newRoot);
        treeUtils.setDescendantCount(newRoot);
        treeUtils.orderTree(newRoot);
        this.getMinLength(newRoot);
        this.preorderTraversal(newRoot, newRoot.getDescendantCount());
        this.getMaxY(newRoot);
        if (newRoot.getDescendantCount() < 200) {
            ImproveUnrooted cunyas = new ImproveUnrooted();
            cunyas.setTreeList(newRoot);
        }
        this.getMinCoords(newRoot);
        this.translateCoords(newRoot);
        return newRoot;
    }

    public void preorderTraversal(TreeElement parent, int rootLeaves) {
        if (!parent.isRoot()) {
            TreePoint pointFather;
            TreeElement father = parent.getFather();
            try {
                pointFather = father.getTreePoint();
            }
            catch (Exception ex) {
                pointFather = new TreePoint(0.0, 0.0);
            }
            double lengthParent = Math.abs(parent.getLength());
            if (lengthParent == 0.0) {
                lengthParent = 1.0;
            }
            double parentW = parent.getW();
            double parentT = parent.getT();
            double fatherT = father.getT();
            double parentLevel = parent.getLevel();
            double divW = 0.5;
            double coordX = Math.cos(parentT + parentW * divW) * lengthParent;
            double coordY = Math.sin(parentT + parentW * divW) * lengthParent;
            TreePoint pointParent = new TreePoint(coordX, coordY);
            TreePoint pointResult = new TreePoint(pointFather, pointParent);
            parent.setX(pointResult.getX());
            parent.setY(pointResult.getY());
            parent.setTreePoint(pointResult);
        }
        double n = parent.getT();
        for (int i = 0; i < parent.size(); ++i) {
            TreeElement children = (TreeElement)parent.get(i);
            int childLeaves = children.getDescendantCount();
            double w = (double)childLeaves / (double)rootLeaves * 2.0 * Math.PI;
            children.setW(w);
            children.setT(n);
            n += children.getW();
            this.preorderTraversal(children, rootLeaves);
        }
    }

    private void getMinCoords(TreeElement parent) {
        double parentX = parent.getX();
        double parentY = parent.getY();
        if (parentX < this.minX) {
            this.minX = parentX;
        }
        if (parentY < this.minY) {
            this.minY = parentY;
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.getMinCoords((TreeElement)parent.get(i));
        }
    }

    private void translateCoords(TreeElement parent) {
        parent.setX(parent.getX() + Math.abs(this.minX));
        parent.setY(parent.getY() + Math.abs(this.minY));
        for (int i = 0; i < parent.size(); ++i) {
            this.translateCoords((TreeElement)parent.get(i));
        }
    }

    private void getMinLength(TreeElement treeList) {
        this.minLength = Math.abs(treeList.getLength());
        this.getMinLength2(treeList);
    }

    private void getMinLength2(TreeElement parent) {
        double parentLength = Math.abs(parent.getLength());
        if (parentLength < this.minLength) {
            this.minLength = parentLength;
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.getMinLength2((TreeElement)parent.get(i));
        }
    }

    private void getMaxY(TreeElement treeList) {
        this.maxY = 0.0;
        this.getMaxY2(treeList);
    }

    private void getMaxY2(TreeElement parent) {
        double parentY = parent.getY();
        if (parentY > this.maxY) {
            this.maxY = parentY;
        }
        Iterator iter = parent.iterator();
        while (iter.hasNext()) {
            this.getMaxY2((TreeElement)iter.next());
        }
    }

    private void invertYAxis(TreeElement treeList) {
        this.invertYAxis2(treeList);
    }

    private void invertYAxis2(TreeElement parent) {
        parent.setY(this.maxY - parent.getY());
        Iterator iter = parent.iterator();
        while (iter.hasNext()) {
            this.invertYAxis2((TreeElement)iter.next());
        }
    }

    private TreeElement getRootLastChild(TreeElement treeList) {
        TreeElement rootLastChild = (TreeElement)treeList.get(treeList.size() - 1);
        return rootLastChild;
    }

    private TreeElement getRootLastGrandchild(TreeElement treeList) {
        TreeElement rootLastChild = this.getRootLastChild(treeList);
        TreeElement rootLastGrandchild = (TreeElement)rootLastChild.get(rootLastChild.size() - 1);
        return rootLastGrandchild;
    }

    private void improveTree(TreeElement treeList) {
        Iterator iter = treeList.iterator();
        while (iter.hasNext()) {
            this.improveTree((TreeElement)iter.next());
        }
    }
}

