/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.coords;

import com.biotechvana.phylograph.TreeElement;
import java.util.Arrays;

public class Phylogram {
    private double scaleY = 10.0;
    private TreeElement treeList;
    private int highestNodeLevel;
    private int countOtu = 0;
    private int negativeType = 1;

    TreeElement getCoords(TreeElement treeList, double maxLength, int negativeType) {
        this.treeList = treeList;
        this.negativeType = negativeType;
        this.calcCoords();
        return treeList;
    }

    void calcCoords() {
        this.countOtu = 0;
        this.computeHighestNodeLevel(this.treeList);
        this.calcX(this.treeList, 0.0);
        this.calcYOtu(this.treeList);
        this.calcYNode();
    }

    private void computeHighestNodeLevel(TreeElement parent) {
        if (parent.isNode()) {
            if (!parent.isVisible()) {
                return;
            }
            if (parent.getLevel() > this.highestNodeLevel) {
                this.highestNodeLevel = parent.getLevel();
            }
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.computeHighestNodeLevel((TreeElement)parent.get(i));
        }
    }

    private void calcX(TreeElement parent, double xParent) {
        if (parent.getLength() < 0.0) {
            switch (this.negativeType) {
                case 0: {
                    parent.setX(xParent + parent.getLength());
                    break;
                }
                case 1: {
                    parent.setX(xParent);
                    break;
                }
                case 2: {
                    parent.setX(xParent + Math.abs(parent.getLength()));
                    break;
                }
                default: {
                    parent.setX(xParent);
                    break;
                }
            }
        } else {
            parent.setX(xParent + parent.getLength());
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.calcX((TreeElement)parent.get(i), parent.getX());
        }
    }

    private void calcYOtu(TreeElement parent) {
        if (parent.isNode()) {
            if (!parent.isVisible()) {
                parent.setY((double)this.countOtu++ * this.scaleY);
                return;
            }
        } else {
            parent.setY((double)this.countOtu++ * this.scaleY);
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.calcYOtu((TreeElement)parent.get(i));
        }
    }

    private void calcYNode() {
        for (int i = this.highestNodeLevel; i >= 0; --i) {
            this.calcYNode2(this.treeList, i);
        }
    }

    private void calcYNode2(TreeElement parent, int level) {
        if (parent.isNode() && parent.getLevel() == level && parent.isVisible()) {
            double[] childHeights = new double[parent.size()];
            for (int j = 0; j < parent.size(); ++j) {
                childHeights[j] = ((TreeElement)parent.get(j)).getY();
            }
            Arrays.sort(childHeights);
            parent.setYChildLow(childHeights[0]);
            parent.setYChildHigh(childHeights[childHeights.length - 1]);
            parent.setY((childHeights[0] + childHeights[childHeights.length - 1]) / 2.0);
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.calcYNode2((TreeElement)parent.get(i), level);
        }
    }
}

