/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.coords;

import com.biotechvana.phylograph.TreeElement;
import java.util.Arrays;

public class Phenogram {
    private double scaleX = 10.0;
    private double scaleY = 10.0;
    private TreeElement treeList;
    private int highestNodeLevel;
    private int countOtu = 0;
    private double highestChildY = 0.0;
    private double lowestChildY = 10000.0;
    private int childNum = 0;
    private int width;

    public TreeElement getCoords(TreeElement treeList, double maxLength) {
        this.treeList = treeList;
        this.scaleX = maxLength;
        this.scaleY = maxLength;
        this.calcCoords();
        return treeList;
    }

    private void calcCoords() {
        this.highestNodeLevel = 0;
        this.countOtu = 0;
        this.getHighestNodeLevel(this.treeList);
        this.childNum = 0;
        this.getChildNum(this.treeList);
        this.width = (int)((double)this.childNum * this.scaleY) / 2;
        this.calcCoordsOtu(this.treeList);
        this.calcCoordsNode(this.treeList);
        this.calcCoordsNodeY(this.treeList);
        this.treeList.setX(0.0);
    }

    private void getHighestNodeLevel(TreeElement parent) {
        if (parent.isNode()) {
            if (!parent.isVisible()) {
                return;
            }
            if (parent.getLevel() > this.highestNodeLevel) {
                this.highestNodeLevel = parent.getLevel();
            }
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.getHighestNodeLevel((TreeElement)parent.get(i));
        }
    }

    private void calcCoordsOtu(TreeElement parent) {
        if (parent.isNode()) {
            if (!parent.isVisible()) {
                parent.setY((double)this.countOtu++ * this.scaleY);
                parent.setX((double)(this.highestNodeLevel + 1) * this.scaleX);
                return;
            }
        } else if (parent.isVisible()) {
            parent.setX((double)this.width - this.scaleY / 2.0);
            parent.setY((double)this.countOtu++ * this.scaleY);
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.calcCoordsOtu((TreeElement)parent.get(i));
        }
    }

    private void calcCoordsNode(TreeElement parent) {
        if (parent.isNode()) {
            if (parent.isVisible()) {
                parent.setX((double)this.width - this.getNodeX(parent));
            } else {
                parent.setX((double)this.width - this.getNodeX(parent));
                return;
            }
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.calcCoordsNode((TreeElement)parent.get(i));
        }
    }

    private void calcCoordsNodeY(TreeElement treeList) {
        for (int i = this.highestNodeLevel; i >= 0; --i) {
            this.calcCoordsNodeY2(treeList, i);
        }
    }

    private void calcCoordsNodeY2(TreeElement parent, int level) {
        if (parent.isNode() && parent.getLevel() == level) {
            double[] childHeights = new double[parent.size()];
            if (!parent.isVisible()) {
                return;
            }
            for (int j = 0; j < parent.size(); ++j) {
                childHeights[j] = ((TreeElement)parent.get(j)).getY();
            }
            Arrays.sort(childHeights);
            parent.setYChildLow(childHeights[0]);
            parent.setYChildHigh(childHeights[childHeights.length - 1]);
            parent.setY((childHeights[0] + childHeights[childHeights.length - 1]) / 2.0);
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.calcCoordsNodeY2((TreeElement)parent.get(i), level);
        }
    }

    private double getMiddleY(TreeElement parent) {
        double middle = 0.0;
        this.highestChildY = 0.0;
        this.lowestChildY = 10000.0;
        this.getChildY(parent);
        middle = (this.highestChildY + this.lowestChildY) / 2.0;
        return middle;
    }

    private void getChildY(TreeElement parent) {
        for (int i = 0; i < parent.size(); ++i) {
            TreeElement child = (TreeElement)parent.get(i);
            double currentY = child.getY();
            if (currentY > this.highestChildY) {
                this.highestChildY = currentY;
            }
            if (currentY < this.lowestChildY) {
                this.lowestChildY = currentY;
            }
            if (!child.isVisible()) {
                return;
            }
            this.getChildY(child);
        }
    }

    private double getNodeX(TreeElement parent) {
        this.childNum = 0;
        this.getChildNum(parent);
        double x = (double)this.childNum * this.scaleY / 2.0;
        return x;
    }

    private void getChildNum(TreeElement parent) {
        if (!parent.isVisible()) {
            ++this.childNum;
            return;
        }
        for (int i = 0; i < parent.size(); ++i) {
            if (!((TreeElement)parent.get(i)).isNode()) {
                ++this.childNum;
            }
            this.getChildNum((TreeElement)parent.get(i));
        }
    }
}

