/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.components;

import com.biotechvana.phylograph.InternalF;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class Node
extends JLabel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -1306786304741908498L;
    private InternalF internalF;
    private int id = 0;
    private long id2 = -1L;
    private int level = 0;
    private JPopupMenu popup;
    private JMenuItem menuRotate;
    private JMenuItem menuHide;
    private JMenuItem menuRoot;
    private JMenuItem menuColor;
    private JMenuItem menuSubtree;
    private JMenuItem menuCluster;
    private JMenuItem menuUnroot;
    private JMenuItem menuRestore;
    private int bootX = 0;
    private int bootY = 0;
    private Node father;
    private boolean root = false;
    private double length;
    private double bootstrap;
    private double treeX;
    private double treeY;
    private double angle1 = 0.0;
    private double angle2 = 0.0;
    private String cluster = "";
    private boolean rooted = false;

    public Node(InternalF internalF, int id, int level, int x, int y) {
        this.internalF = internalF;
        this.id = id;
        this.level = level;
        this.bootX = x;
        this.bootY = y;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.popup = this.createPopupMenu();
        this.add(this.popup);
        this.setComponentPopupMenu(this.popup);
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        this.menuRotate = new JMenuItem("Rotate branch");
        this.menuHide = new JMenuItem("Hide/Show node");
        this.menuRoot = new JMenuItem("Root outgroup");
        this.menuColor = new JMenuItem("Set color");
        this.menuSubtree = new JMenuItem("Edit subtree");
        this.menuCluster = new JMenuItem("Save cluster");
        this.menuRestore = new JMenuItem("Unroot");
        popup.add(this.menuRoot);
        popup.add(this.menuRestore);
        popup.add(this.menuRotate);
        popup.add(this.menuHide);
        popup.add(this.menuColor);
        popup.add(this.menuSubtree);
        popup.add(this.menuCluster);
        this.menuRotate.addActionListener(new RotateListener());
        this.menuHide.addActionListener(new HideListener());
        this.menuRoot.addActionListener(new RootListener());
        this.menuColor.addActionListener(new ColorListener());
        this.menuSubtree.addActionListener(new SubtreeListner());
        this.menuCluster.addActionListener(new ClusterListener());
        this.menuRestore.addActionListener(new RestoreListener());
        return popup;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.setCursor(new Cursor(12));
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.setCursor(new Cursor(0));
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (this.internalF.isInverted()) {
            return;
        }
        this.popup = this.createPopupMenu();
        if (this.isRoot()) {
            this.popup.remove(this.menuHide);
        }
        if (this.internalF.getTreeView().equalsIgnoreCase("unrooted")) {
            return;
        }
        if (this.internalF.isRooted()) {
            this.popup.remove(this.menuRoot);
        } else {
            this.popup.remove(this.menuRestore);
        }
        if (this.isRooted()) {
            this.setRooted(false);
        } else {
            this.setRooted(true);
        }
        if (me.isPopupTrigger()) {
            this.popup.show(this, me.getX(), me.getY());
        }
        if (!this.internalF.getTreeView().equalsIgnoreCase("unrooted")) {
            return;
        }
        if (this.isRoot()) {
            return;
        }
        if (me.getModifiersEx() == 2) {
            return;
        }
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
        if (!this.internalF.getTreeView().equalsIgnoreCase("unrooted")) {
            return;
        }
        if (this.isRoot()) {
            return;
        }
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }

    private void rotate() {
        this.internalF.setTreeList(this.internalF.getTreeUtils().rotateNode(this.internalF.getTreeList(), this.id));
        this.internalF.setTreeList(this.internalF.getTreeGram().getCoords(this.internalF.getTreeList(), this.internalF.getTreeView(), this.internalF.getMaxLength(), this.internalF.negativeType));
        this.internalF.getPanelTree().setTreeList(this.internalF.getTreeList());
        this.internalF.moveElements(this.internalF.getTreeList());
        if (this.internalF.getTreeView().equalsIgnoreCase("slanted")) {
            this.internalF.changeTreeType("cladogram");
            this.internalF.changeTreeType("slanted");
        }
    }

    private void hideNode() {
        this.internalF.setTreeList(this.internalF.getTreeUtils().changeVisibilityNode(this.internalF.getTreeList(), this.id));
        this.internalF.setTreeList(this.internalF.getTreeGram().getCoords(this.internalF.getTreeList(), this.internalF.getTreeView(), this.internalF.getMaxLength(), this.internalF.negativeType));
        this.internalF.getPanelTree().setTreeList(this.internalF.getTreeList());
        this.internalF.moveElements(this.internalF.getTreeList());
        this.internalF.updateClusters();
    }

    private void rootOutgroup() {
        if (this.internalF.getOrginalRootId2() == this.id2) {
            this.unrootOutgroup();
            return;
        }
        if (this.internalF.isRooted()) {
            this.internalF.setTreeList(this.internalF.getAuxList());
            this.internalF.setRooted(false);
        }
        this.internalF.setAuxList(this.internalF.getTreeUtils().copyTree(this.internalF.getTreeList()));
        this.internalF.setTreeList(this.internalF.getTreeUtils().rootOutgroup(this.internalF.getTreeList(), this.id2, true));
        try {
            this.internalF.setTreeList(this.internalF.getTreeGram().getCoords(this.internalF.getTreeList(), this.internalF.getTreeView(), this.internalF.getMaxLength(), this.internalF.negativeType));
        }
        catch (Exception ex) {
            this.unrootOutgroup();
            return;
        }
        this.internalF.getPanelTree().setTreeList(this.internalF.getTreeList());
        this.internalF.createElements();
        this.internalF.setRooted(true);
    }

    private void unrootOutgroup() {
        this.internalF.setAuxList(null);
        this.internalF.setTreeList(this.internalF.getOriginalTreeList());
        this.internalF.setTreeList(this.internalF.getTreeGram().getCoords(this.internalF.getTreeList(), this.internalF.getTreeView(), this.internalF.getMaxLength(), this.internalF.negativeType));
        this.internalF.getPanelTree().setTreeList(this.internalF.getTreeList());
        this.internalF.createElements();
        this.internalF.setRooted(false);
        if (this.internalF.getTreeView().equalsIgnoreCase("slanted")) {
            this.internalF.changeTreeType("cladogram");
            this.internalF.changeTreeType("slanted");
        }
    }

    private void changeColor() {
        Color newColor = JColorChooser.showDialog(null, "Select node color", Color.BLACK);
        this.internalF.setTreeList(this.internalF.getTreeUtils().setLineColor(this.internalF.getTreeList(), this.id, newColor));
        this.internalF.updatePanel();
    }

    private void saveCluster() {
        this.internalF.saveCluster(this.id);
    }

    public void setBootPos(int x, int y) {
        this.bootX = x - this.getX();
        this.bootY = y - this.getY();
    }

    public void setFather(Node father) {
        this.father = father;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public int getId() {
        return this.id;
    }

    public int getLevel() {
        return this.level;
    }

    public int getBootX() {
        return this.bootX;
    }

    public int getBootY() {
        return this.bootY;
    }

    public Node getFather() {
        return this.father;
    }

    public boolean isRoot() {
        return this.root;
    }

    public void selectSubtree() {
        this.internalF.selectSubtree(this);
    }

    public double calculaDistancia(int x2, int y2, int x1, int y1) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        double dist = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
        return dist;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public double getBootstrap() {
        return this.bootstrap;
    }

    public void setBootstrap(double bootstrap) {
        this.bootstrap = bootstrap;
    }

    public double getTreeX() {
        return this.treeX;
    }

    public void setTreeX(double treeX) {
        this.treeX = treeX;
    }

    public double getTreeY() {
        return this.treeY;
    }

    public void setTreeY(double treeY) {
        this.treeY = treeY;
    }

    public double getAngle1() {
        return this.angle1;
    }

    public void setAngle1(double angle1) {
        this.angle1 = angle1;
    }

    public double getAngle2() {
        return this.angle2;
    }

    public void setAngle2(double angle2) {
        this.angle2 = angle2;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public long getId2() {
        return this.id2;
    }

    public void setId2(long id2) {
        this.id2 = id2;
    }

    public boolean isRooted() {
        return this.rooted;
    }

    public void setRooted(boolean rooted) {
        this.rooted = rooted;
    }

    class RotateListener
    implements ActionListener {
        RotateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Node.this.rotate();
        }
    }

    class HideListener
    implements ActionListener {
        HideListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Node.this.hideNode();
        }
    }

    class RootListener
    implements ActionListener {
        RootListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Node.this.rootOutgroup();
        }
    }

    class ColorListener
    implements ActionListener {
        ColorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Node.this.changeColor();
        }
    }

    class SubtreeListner
    implements ActionListener {
        SubtreeListner() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Node.this.selectSubtree();
        }
    }

    class ClusterListener
    implements ActionListener {
        ClusterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Node.this.saveCluster();
        }
    }

    class RestoreListener
    implements ActionListener {
        RestoreListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Node.this.unrootOutgroup();
        }
    }

    class UnrootListener
    implements ActionListener {
        UnrootListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Node.this.unrootOutgroup();
        }
    }
}

