/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.components;

import com.biotechvana.phylograph.InternalF;
import com.biotechvana.phylograph.TreeElement;
import com.biotechvana.phylograph.View;
import com.biotechvana.phylograph.components.ClusterFull;
import com.biotechvana.phylograph.treeutils.MaxLevel;
import com.biotechvana.phylograph.treeutils.MaxY;
import com.biotechvana.phylograph.treeutils.MinY;
import com.biotechvana.phylograph.xml.XMLToCluster;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class ClusterManager {
    private List<String> otuNames;
    private MaxY nodeMaxY = new MaxY();
    private MinY nodeMinY = new MinY();

    public File openClusterFile(InternalF internalF, View view, String prefFile) {
        JFileChooser chooser = new JFileChooser(prefFile);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle("Open cluster file");
        chooser.setFileSelectionMode(0);
        int sel = chooser.showOpenDialog(view);
        if (sel == 0) {
            File selectedFile = chooser.getSelectedFile();
            return selectedFile;
        }
        return null;
    }

    public List<ClusterFull> getClusterList(InternalF internalF, File clusterFile) {
        XMLToCluster xtc = new XMLToCluster();
        List<ClusterFull> clusterList = xtc.readClusters(internalF, clusterFile);
        return clusterList;
    }

    public void paintClusters(InternalF internalF, List<ClusterFull> clusterList) {
        this.traverseTree(internalF, clusterList);
    }

    public File createClusterFile(View view, String prefFile) {
        JFileChooser chooser = new JFileChooser(prefFile);
        String text = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<clusters>\n</clusters>\n";
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle("Select or create a cluster file");
        chooser.setFileSelectionMode(0);
        int sel = chooser.showSaveDialog(view);
        if (sel == 0) {
            File selectedFile = chooser.getSelectedFile();
            try {
                FileWriter fw = new FileWriter(selectedFile);
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(text);
                bw.close();
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return selectedFile;
        }
        return null;
    }

    public ClusterFull createCluster(View view, InternalF internalF, TreeElement node) {
        String clusterName;
        do {
            if (!(clusterName = JOptionPane.showInputDialog(view, (Object)"Enter cluster name")).equals("")) continue;
            JOptionPane.showMessageDialog(view, "Invalid cluster name", "Alert", 1);
        } while (clusterName.equals(""));
        ClusterFull clusterFull = new ClusterFull(internalF, clusterName, this.getOtuNames(node));
        MaxLevel treeMaxLevel = new MaxLevel();
        TreeElement treeList = internalF.getTreeList();
        int maxLevel = treeMaxLevel.getMaxLevel(treeList);
        double scaleFactorY = internalF.getScaleFactorY();
        int marginY = internalF.getMarginY();
        int maxY = (int)(this.nodeMaxY.getMaxY(node) * scaleFactorY + (double)marginY);
        int minY = (int)(this.nodeMinY.getMinY(node) * scaleFactorY + (double)marginY);
        int sx = (int)(internalF.getTreeUtils().getMaxDimension(internalF.getTreeList()).getWidth() * internalF.getScaleFactorX()) + internalF.getMarginX();
        int startX = sx + (maxLevel - node.getLevel()) * 20;
        clusterFull.setBounds(startX, minY, clusterFull.getWidth(), maxY - minY);
        return clusterFull;
    }

    public void saveClusterInFile(File clusterFile, List<ClusterFull> clusterFull) {
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<clusters>");
        for (ClusterFull cluster : clusterFull) {
            String clusterName = cluster.getClusterName();
            String[] otuNames = cluster.getOtuNames();
            sbuffer.append("\n<cluster name=\"" + clusterName + "\">");
            for (int i = 0; i < otuNames.length; ++i) {
                sbuffer.append("\n<otu>" + otuNames[i] + "</otu>");
            }
            sbuffer.append("\n</cluster>");
        }
        sbuffer.append("\n</clusters>");
        try {
            FileWriter fw = new FileWriter(clusterFile);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(sbuffer.toString());
            bw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void paintCluster(InternalF internalF, TreeElement node, ClusterFull clusterFull, int maxLevel) {
        double scaleFactorX = internalF.getScaleFactorX();
        double scaleFactorY = internalF.getScaleFactorY();
        int marginX = internalF.getMarginX();
        int marginY = internalF.getMarginY();
        int x = (int)(node.getX() * scaleFactorX) + marginX;
        int y = (int)(node.getY() * scaleFactorY) + marginY;
        int maxY = (int)(this.nodeMaxY.getMaxY(node) * scaleFactorY + (double)marginY);
        int minY = (int)(this.nodeMinY.getMinY(node) * scaleFactorY + (double)marginY);
        int sx = (int)(internalF.getTreeUtils().getMaxDimension(internalF.getTreeList()).getWidth() * internalF.getScaleFactorX()) + internalF.getMarginX();
        int startX = sx + (maxLevel - node.getLevel()) * 20;
        clusterFull.setBounds(startX, minY, clusterFull.getWidth(), maxY - minY);
        internalF.getPanelTree().add(clusterFull);
        internalF.updatePanel();
    }

    public String[] getOtuNames(TreeElement node) {
        this.otuNames = new ArrayList<String>();
        this.getOtuNames2(node);
        return this.otuNames.toArray(new String[this.otuNames.size()]);
    }

    private void getOtuNames2(TreeElement parent) {
        if (!parent.isNode()) {
            this.otuNames.add(parent.getText());
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.getOtuNames2((TreeElement)parent.get(i));
        }
    }

    public void traverseTree(InternalF internalF, List<ClusterFull> clusterList) {
        MaxLevel treeMaxLevel = new MaxLevel();
        TreeElement treeList = internalF.getTreeList();
        int maxLevel = treeMaxLevel.getMaxLevel(treeList);
        this.traverseTree2(internalF, treeList, clusterList, maxLevel);
    }

    private void traverseTree2(InternalF internalF, TreeElement parent, List<ClusterFull> clusterList, int maxLevel) {
        if (parent.isNode()) {
            if (!parent.isVisible()) {
                return;
            }
            String[] otus = this.getOtuNames(parent);
            for (ClusterFull cluster : clusterList) {
                boolean match = this.matchOtus(otus, cluster.getOtuNames());
                if (!match) continue;
                this.paintCluster(internalF, parent, cluster, maxLevel);
            }
        }
        for (TreeElement child : parent) {
            this.traverseTree2(internalF, child, clusterList, maxLevel);
        }
    }

    public boolean matchOtus(String[] treeOtus, String[] clusterOtus) {
        if (treeOtus.length != clusterOtus.length) {
            return false;
        }
        Arrays.sort(treeOtus);
        Arrays.sort(clusterOtus);
        for (int i = 0; i < treeOtus.length; ++i) {
            if (treeOtus[i].equalsIgnoreCase(clusterOtus[i])) continue;
            return false;
        }
        return true;
    }

    public boolean clusterExists(ClusterFull clusterFull, List<ClusterFull> clusterFullList) {
        if (clusterFullList != null) {
            for (int i = 0; i < clusterFullList.size(); ++i) {
                ClusterFull clusterTemp = clusterFullList.get(i);
                if (!this.matchOtus(clusterFull.getOtuNames(), clusterTemp.getOtuNames())) continue;
                return true;
            }
        }
        return false;
    }
}

