/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.components;

import com.biotechvana.phylograph.InternalF;
import com.biotechvana.phylograph.dialogs.FontDialogCluster;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Random;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class ClusterFull
extends JLabel
implements MouseListener,
MouseMotionListener,
Serializable {
    private static final long serialVersionUID = 5105509037286848773L;
    private long id = 0L;
    private int posX = 0;
    private int posY = 0;
    private int initialX = 0;
    private int initialY = 0;
    private int initialWidth = 0;
    private int initialHeight = 0;
    private int RIGHT_SHIFT_MASK = 1088;
    private JPopupMenu pop = new JPopupMenu();
    private InternalF internalF = null;
    private String[] otuNames = null;
    private Color colorText = Color.BLACK;
    private Color colorStroke = Color.BLACK;
    private Color colorBorder = Color.BLACK;
    private Color colorBackground = Color.WHITE;
    private boolean inverted = false;
    private boolean border = false;
    private boolean background = true;
    private boolean vertical = false;
    private boolean transparent = false;
    private int paddingX = 6;
    private int paddingY = 2;
    private String clusterName = "";
    private ButtonGroup groupTransparent = new ButtonGroup();
    private JRadioButtonMenuItem menuRTransparentYes = new JRadioButtonMenuItem("Yes", false);
    private JRadioButtonMenuItem menuRTransparentNo = new JRadioButtonMenuItem("No", true);

    public ClusterFull(InternalF internalF, String clusterName, String[] otuNames) {
        this.id = new Random().nextLong();
        this.otuNames = otuNames;
        this.internalF = internalF;
        this.clusterName = clusterName;
        this.setHorizontalAlignment(4);
        this.setVerticalAlignment(0);
        this.setText("");
        this.setBounds(this.posX, this.posY, 30 + this.getStringWidth() + this.paddingX * 2, 100);
        this.setForeground(Color.WHITE);
        this.setOpaque(false);
        this.setToolTipText("<html><center>Press <b>Shift</b> and<br> drag mouse to resize</center></html>");
        this.pop = this.createPop();
        this.setComponentPopupMenu(this.pop);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.inverted) {
            int textX = this.paddingX;
            int textY = this.getHeight() / 2 + this.getStringHeight() / 4;
            int width = 10 + this.getStringWidth() + this.paddingX * 2;
            int boxX = this.paddingX - 1;
            int boxY = textY - this.getStringHeight() * 3 / 4;
            g2.setColor(this.colorStroke);
            g2.drawLine(this.getWidth() - 1, 1, width, 1);
            g2.drawLine(this.getWidth() - 1, this.getHeight() - 1, width, this.getHeight() - 1);
            g2.drawLine(width, 1, width, this.getHeight() - 1);
            if (this.background) {
                g2.setColor(this.colorBackground);
                g2.fillRect(boxX - this.paddingX + 1, boxY - this.paddingY, this.getStringWidth() + this.paddingX * 2 + 1, this.getStringHeight() + this.paddingY * 2);
            }
            if (this.border) {
                g2.setColor(this.colorBorder);
                g2.drawRect(boxX - this.paddingX + 1, boxY - this.paddingY, this.getStringWidth() + this.paddingX * 2, this.getStringHeight() + this.paddingY * 2);
            }
            g2.setColor(this.colorText);
            g2.drawString(this.getClusterName(), textX, textY);
        } else {
            int textX = this.getWidth() - this.getStringWidth() - this.paddingX;
            int textY = this.getHeight() / 2 + this.getStringHeight() / 4;
            int width = this.getWidth() - this.getStringWidth() - 10 - this.paddingX * 2;
            int boxX = textX;
            int boxY = textY - this.getStringHeight() * 3 / 4;
            g2.setColor(this.colorStroke);
            g2.drawLine(1, 1, width, 1);
            g2.drawLine(1, this.getHeight() - 1, width, this.getHeight() - 1);
            g2.drawLine(width, 1, width, this.getHeight() - 1);
            if (this.background) {
                g2.setColor(this.colorBackground);
                g2.fillRect(boxX - this.paddingX, boxY - this.paddingY, this.getStringWidth() + this.paddingX * 2, this.getStringHeight() + this.paddingY * 2);
            }
            if (this.border) {
                g2.setColor(this.colorBorder);
                g2.drawRect(boxX - this.paddingX - 1, boxY - this.paddingY, this.getStringWidth() + this.paddingX * 2, this.getStringHeight() + this.paddingY * 2);
            }
            g2.setColor(this.colorText);
            g2.drawString(this.getClusterName(), textX, textY);
        }
    }

    private JPopupMenu createPop() {
        JPopupMenu pop = new JPopupMenu();
        JMenuItem menuText = new JMenuItem("Edit text");
        JMenuItem menuFont = new JMenuItem("Font and colors");
        JMenu menuTransparent = new JMenu("Transparent");
        JMenuItem menuRemove = new JMenuItem("Remove");
        JMenuItem menuRotate = new JMenuItem("Rotate");
        this.groupTransparent.add(this.menuRTransparentYes);
        this.groupTransparent.add(this.menuRTransparentNo);
        menuTransparent.add(this.menuRTransparentYes);
        menuTransparent.add(this.menuRTransparentNo);
        pop.add(menuText);
        pop.add(menuFont);
        pop.add(menuRotate);
        pop.add(menuRemove);
        menuRemove.addActionListener(new RemoveListener());
        menuText.addActionListener(new ChangeTextListener());
        menuRotate.addActionListener(new RotateListener());
        menuFont.addActionListener(new ChangeFontListener());
        return pop;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if ((me.getModifiersEx() & this.RIGHT_SHIFT_MASK) == this.RIGHT_SHIFT_MASK) {
            this.setInitialX(me.getX());
            this.setInitialY(me.getY());
            this.setInitialWidth(this.getWidth());
            this.setInitialHeight(this.getHeight());
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.pop.show(this, me.getX(), me.getY());
        }
        this.internalF.updatePanel();
    }

    @Override
    public void mouseMoved(MouseEvent mme) {
    }

    @Override
    public void mouseDragged(MouseEvent mme) {
        if ((mme.getModifiersEx() & this.RIGHT_SHIFT_MASK) == this.RIGHT_SHIFT_MASK) {
            int newWidth = this.getInitialWidth() + (mme.getX() - this.getInitialX());
            int newHeight = this.getInitialHeight() + (mme.getY() - this.getInitialY());
            int minWidth = this.getStringWidth() + 10 + this.paddingX * 2;
            int minHeight = this.getStringHeight() - 10;
            if (newWidth > minWidth && newHeight > minHeight) {
                this.setBounds(this.getX(), this.getY(), newWidth, newHeight);
            }
        }
        if (mme.getModifiersEx() == 1024) {
            this.setPosX(this.getPosX() + (mme.getX() - this.getWidth() / 2));
            this.setPosY(this.getPosY() + (mme.getY() - this.getHeight() / 2));
            this.setLocation(this.getPosX(), this.getPosY());
        }
    }

    private int getInitialHeight() {
        return this.initialHeight;
    }

    private int getInitialWidth() {
        return this.initialWidth;
    }

    private int getInitialX() {
        return this.initialX;
    }

    private int getInitialY() {
        return this.initialY;
    }

    public int getStringWidth() {
        return this.getFontMetrics(this.getFont()).stringWidth(this.clusterName);
    }

    public int getStringHeight() {
        return this.getFontMetrics(this.getFont()).getHeight();
    }

    private void setInitialHeight(int initialHeight) {
        this.initialHeight = initialHeight;
    }

    private void setInitialWidth(int initialWidth) {
        this.initialWidth = initialWidth;
    }

    private void setInitialX(int initialX) {
        this.initialX = initialX;
    }

    private void setInitialY(int initialY) {
        this.initialY = initialY;
    }

    private int getPosX() {
        return this.posX;
    }

    private void setPosX(int posX) {
        this.posX = posX;
    }

    private int getPosY() {
        return this.posY;
    }

    private void setPosY(int posY) {
        this.posY = posY;
    }

    private InternalF getInternalF() {
        return this.internalF;
    }

    public void setInternalF(InternalF internalF) {
        this.internalF = internalF;
    }

    public void removeFromScreen() {
        try {
            this.getInternalF().getPanelTree().remove(this);
        }
        catch (Exception ex) {
            System.out.println("Error deleting cluster");
        }
    }

    public void removeCluster() {
        this.getInternalF().deleteCluster(this);
    }

    public void changeText() {
        String newText = JOptionPane.showInputDialog(this.internalF, "New text: ", this.getText());
        if (newText == null) {
            return;
        }
        this.setClusterName(newText);
        this.setBounds(this.getX(), this.getY(), this.getWidth() + this.getStringWidth(), this.getHeight());
        int res = JOptionPane.showConfirmDialog(this.internalF, "Save in cluster file also?", "Edit cluster name", 0);
        if (res == 0) {
            this.internalF.getClusterManager().saveClusterInFile(this.internalF.getClusterFile(), this.internalF.getClusterFullList());
        }
        this.repaint();
    }

    public void rotate() {
        if (this.isInverted()) {
            this.setInverted(false);
        } else {
            this.setInverted(true);
        }
        this.repaint();
    }

    public String[] getOtuNames() {
        return this.otuNames;
    }

    public void setOtuNames(String[] otuNames) {
        this.otuNames = otuNames;
    }

    public Color getColorStroke() {
        return this.colorStroke;
    }

    public Color getColorText() {
        return this.colorText;
    }

    public void setColorStroke(Color colorStroke) {
        this.colorStroke = colorStroke;
        this.repaint();
    }

    public void setColorText(Color colorText) {
        this.colorText = colorText;
        this.repaint();
    }

    public void changeFont() {
        int oldStringWidth = this.getStringWidth();
        int oldPaddingX = this.getPaddingX();
        FontDialogCluster fontDialogCluster = this.internalF.getFontDialogCluster();
        fontDialogCluster.showDialog(this.getFont(), this.getColorText(), this.getColorStroke(), this.getColorBackground(), this.isBorder(), this.colorBorder, this.getPaddingX(), this.getPaddingY());
        this.setFont(fontDialogCluster.getFont());
        this.setColorText(fontDialogCluster.getTextColor());
        this.setColorStroke(fontDialogCluster.getStrokeColor());
        this.setColorBackground(fontDialogCluster.getBackColor());
        this.setBorder(fontDialogCluster.getBorder());
        this.setColorBorder(fontDialogCluster.getColorBorder());
        this.setPaddingX(fontDialogCluster.getPaddingX());
        this.setPaddingY(fontDialogCluster.getPaddingY());
        boolean applyAll = fontDialogCluster.getApplyToAll();
        if (applyAll) {
            this.internalF.setAllClusterFonts(this.getFont(), this.getColorText(), this.getColorStroke(), this.getColorBackground(), this.isBorder(), this.getColorBorder(), this.getPaddingX(), this.getPaddingY());
        }
        this.setBounds(this.getX(), this.getY(), this.getWidth() - oldStringWidth + this.getStringWidth() - oldPaddingX + this.getPaddingX(), this.getHeight());
    }

    public void changeFont(Font font) {
        int oldStringWidth = this.getStringWidth();
        this.setFont(font);
        this.setBounds(this.getX(), this.getY(), this.getWidth() - oldStringWidth + this.getStringWidth(), this.getHeight());
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
        this.repaint();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
        this.repaint();
    }

    public boolean isBorder() {
        return this.border;
    }

    public Color getColorBackground() {
        return this.colorBackground;
    }

    public Color getColorBorder() {
        return this.colorBorder;
    }

    public int getPaddingX() {
        return this.paddingX;
    }

    public int getPaddingY() {
        return this.paddingY;
    }

    public void setBorder(boolean border) {
        this.border = border;
        this.repaint();
    }

    public void setColorBackground(Color colorBackground) {
        this.colorBackground = colorBackground;
        this.repaint();
    }

    public void setColorBorder(Color colorBorder) {
        this.colorBorder = colorBorder;
        this.repaint();
    }

    public void setPaddingX(int paddingX) {
        this.paddingX = paddingX;
        this.repaint();
    }

    public void setPaddingY(int paddingY) {
        this.paddingY = paddingY;
        this.repaint();
    }

    public boolean isBackground() {
        return this.background;
    }

    public void setBackground(boolean background) {
        this.background = background;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    class RemoveListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = 7132753606351745342L;

        RemoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ClusterFull.this.removeCluster();
        }
    }

    class ChangeTextListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = 124310263499260328L;

        ChangeTextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ClusterFull.this.changeText();
        }
    }

    class RotateListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = 1334197767869776298L;

        RotateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ClusterFull.this.rotate();
        }
    }

    class ChangeFontListener
    implements ActionListener {
        ChangeFontListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ClusterFull.this.changeFont();
        }
    }
}

