/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.components;

import com.biotechvana.phylograph.InternalF;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;

public class Bootstrap
extends JLabel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 9148836062097443713L;
    private int id = 0;
    private int posX;
    private int posY;
    private InternalF internalF;

    public Bootstrap(InternalF internalF, int id, double boot, int posX, int posY) {
        this.internalF = internalF;
        this.id = id;
        this.posX = posX;
        this.posY = posY;
        this.setFont(internalF.fontArray[3]);
        this.setValue(boot);
        this.setForeground(internalF.colorArray[3]);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBounds(posX, posY, this.getStringWidth(), this.getStringHeight());
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.internalF.getNodeArray()[this.id].setBootPos(this.posX, this.posY);
    }

    @Override
    public void mouseDragged(MouseEvent mme) {
        this.posX += mme.getX() - this.getWidth() / 2;
        this.posY += mme.getY() - this.getHeight() / 2;
        this.setLocation(this.posX, this.posY);
    }

    @Override
    public void mouseMoved(MouseEvent mme) {
    }

    public void setValue(double value) {
        if (value >= 1.0) {
            this.setText(String.valueOf((int)Math.round(value)));
        } else {
            this.setText(String.valueOf(value));
        }
    }

    public double getValue() {
        return Double.parseDouble(this.getText());
    }

    public void changeFont(Font font) {
        this.setFont(font);
        this.setBounds(this.getX(), this.getY() - this.getStringHeight() / 2, this.getStringWidth() + 2, this.getStringHeight());
    }

    public void changeColor(Color colorText) {
        this.setForeground(colorText);
    }

    private int getStringWidth() {
        return this.getFontMetrics(this.getFont()).stringWidth(this.getText());
    }

    private int getStringHeight() {
        return this.getFontMetrics(this.getFont()).getHeight();
    }
}

