/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph.components;

import com.biotechvana.phylograph.InternalF;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class Attachment
extends JLabel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -5316349518826312831L;
    private int id = 0;
    private int posX;
    private int posY;
    private JPopupMenu popup;
    private int initialX;
    private Color colorText;
    private boolean group = true;
    private int otuMargin;
    private JMenuItem menuGroup = new JMenuItem("Ungroup");
    private InternalF internalF;

    public Attachment(InternalF internalF, int id, String text, int posX, int posY) {
        super(text, 0);
        this.setInternalF(internalF);
        this.setId(id);
        this.setText(text);
        this.setPosX(posX);
        this.setPosY(posY);
        this.setFont(internalF.fontArray[4]);
        this.setForeground(Color.BLACK);
        this.setOtuMargin(internalF.getAttachmentDistance());
        this.setBounds(this.getPosX(), this.getPosY(), this.getStringWidth(), this.getStringHeight());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.popup = this.createPopup();
        this.setComponentPopupMenu(this.popup);
    }

    private JPopupMenu createPopup() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuRemove = new JMenuItem("Remove");
        JMenuItem menuGroupall = new JMenuItem("Group all");
        JMenuItem menuUngroupall = new JMenuItem("Ungroup all");
        popup.add(menuRemove);
        popup.add(this.menuGroup);
        popup.add(menuGroupall);
        popup.add(menuUngroupall);
        menuRemove.addActionListener(new RemoveListener());
        this.menuGroup.addActionListener(new GroupListener());
        menuGroupall.addActionListener(new GroupAllListener());
        menuUngroupall.addActionListener(new UngroupAllListener());
        return popup;
    }

    private void removeAttachment() {
        this.getInternalF().getPanelTree().remove(this);
        this.getInternalF().getAttachmentList().remove(this);
        this.setEnabled(false);
    }

    private void groupAttachment() {
        if (this.getGroup()) {
            this.setGroup(false);
            this.menuGroup.setText("Group");
        } else {
            this.setGroup(true);
            this.menuGroup.setText("Ungroup");
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.setCursor(new Cursor(12));
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.setCursor(new Cursor(0));
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.setInitialX(this.getX());
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.popup.show(this, me.getX(), me.getY());
        } else {
            int dif = this.getPosX() - this.getInitialX();
            if (this.getGroup()) {
                this.getInternalF().setAttachmentDistance(this.getInternalF().getAttachmentDistance() + dif);
                this.setOtuMargin(this.getInternalF().getAttachmentDistance());
                this.getInternalF().moveAttachment();
            } else {
                this.setOtuMargin(this.getOtuMargin() + dif);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mme) {
        this.setPosX(this.getPosX() + mme.getX() - this.getWidth() / 2);
        this.setLocation(this.getPosX(), this.getY());
    }

    @Override
    public void mouseMoved(MouseEvent mme) {
    }

    public int getId() {
        return this.id;
    }

    public boolean isGroup() {
        return this.group;
    }

    public int getOtuMargin() {
        return this.otuMargin;
    }

    public void setPosX(int posX) {
        this.posX = posX;
    }

    public void setPosY(int posY) {
        this.posY = posY;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public boolean getGroup() {
        return this.group;
    }

    public void changeFont(Font newFont) {
        this.setFont(newFont);
        this.setBounds(this.getX(), this.getY() - this.getStringHeight() / 2, this.getStringWidth() + 2, this.getStringHeight());
    }

    public void changeColor(Color newColor) {
        this.colorText = newColor;
        this.setForeground(this.colorText);
    }

    private int getStringWidth() {
        return this.getFontMetrics(this.getFont()).stringWidth(this.getText());
    }

    public int getStringHeight() {
        return this.getFontMetrics(this.getFont()).getHeight();
    }

    private InternalF getInternalF() {
        return this.internalF;
    }

    private void setInternalF(InternalF internalF) {
        this.internalF = internalF;
    }

    private void setId(int id) {
        this.id = id;
    }

    private int getPosX() {
        return this.posX;
    }

    private int getPosY() {
        return this.posY;
    }

    private void setOtuMargin(int otuMargin) {
        this.otuMargin = otuMargin;
    }

    private int getInitialX() {
        return this.initialX;
    }

    private void setInitialX(int initialX) {
        this.initialX = initialX;
    }

    class RemoveListener
    implements ActionListener {
        RemoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Attachment.this.removeAttachment();
        }
    }

    class GroupListener
    implements ActionListener {
        GroupListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Attachment.this.groupAttachment();
        }
    }

    class GroupAllListener
    implements ActionListener {
        GroupAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Attachment.this.getInternalF().attachmentGroupAll(true);
        }
    }

    class UngroupAllListener
    implements ActionListener {
        UngroupAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Attachment.this.getInternalF().attachmentGroupAll(false);
        }
    }
}

