/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph;

import com.biotechvana.phylograph.InternalF;
import com.biotechvana.phylograph.TreeElement;
import com.biotechvana.phylograph.utils.ImageDim;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;

public class TreeUtils_original {
    private double minLength = 0.0;
    private double maxLength = 0.0;
    private double minBootstrap = 0.0;
    private double maxBootstrap = 0.0;
    private int maxLevel = 0;
    private int countOtu = 0;
    private int countNode = 0;
    private int descendantCount = 0;
    private TreeElement nodoRaiz;
    private TreeElement nodoB;
    private ImageDim imageDim = new ImageDim();
    private ArrayList<String> listOtuLength = new ArrayList();
    private double minY;
    private double maxY;

    public TreeElement changeOtuAttribute(TreeElement treeList, int id, String attribute, String value) {
        this.changeOtuAttribute2(treeList, id, attribute, value);
        return treeList;
    }

    private void changeOtuAttribute2(TreeElement parent, int id, String attribute, String value) {
        if (!parent.isNode() && parent.getId() == id) {
            if (attribute.equalsIgnoreCase("text")) {
                parent.setText(value);
            } else if (attribute.equalsIgnoreCase("link")) {
                parent.setLink(value);
            } else if (attribute.equalsIgnoreCase("cluster")) {
                parent.setCluster(value);
            } else if (!attribute.equalsIgnoreCase("color") && !attribute.equalsIgnoreCase("font")) {
                if (attribute.equalsIgnoreCase("x")) {
                    parent.setX(Double.parseDouble(value));
                } else if (attribute.equalsIgnoreCase("y")) {
                    parent.setY(Double.parseDouble(value));
                }
            }
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.changeOtuAttribute((TreeElement)parent.get(i), id, attribute, value);
        }
    }

    public TreeElement setLineColor(TreeElement treeList, int id, Color newColor) {
        this.setLineColor2(treeList, id, newColor);
        return treeList;
    }

    private void setLineColor2(TreeElement parent, int id, Color newColor) {
        if (parent.isNode() && parent.getId() == id) {
            this.setLineColor3(parent, newColor);
            return;
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.setLineColor2((TreeElement)parent.get(i), id, newColor);
        }
    }

    private void setLineColor3(TreeElement parent, Color newColor) {
        parent.setColorLine(newColor);
        for (int i = 0; i < parent.size(); ++i) {
            this.setLineColor3((TreeElement)parent.get(i), newColor);
        }
    }

    public TreeElement changeVisibilityNode(TreeElement treeList, int id) {
        this.changeVisibilityNode2(treeList, id);
        return treeList;
    }

    private void changeVisibilityNode2(TreeElement parent, int id) {
        if (parent.isNode() && parent.getId() == id) {
            if (parent.isVisible()) {
                parent.setVisible(false);
            } else {
                parent.setVisible(true);
            }
            return;
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.changeVisibilityNode2((TreeElement)parent.get(i), id);
        }
    }

    public TreeElement rotateNode(TreeElement treeList, int id) {
        this.rotateNode2(treeList, id);
        return treeList;
    }

    private void rotateNode2(TreeElement parent, int id) {
        if (parent.isNode() && parent.getId() == id) {
            this.rotateNode3(parent);
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.rotateNode2((TreeElement)parent.get(i), id);
        }
    }

    private void rotateNode3(TreeElement parent) {
        int i;
        int childNum = (int)Math.ceil((double)parent.size() / 2.0);
        for (i = 0; i < childNum; ++i) {
            TreeElement tmp = (TreeElement)parent.get(i);
            parent.set(i, parent.get(parent.size() - (i + 1)));
            parent.set(parent.size() - (i + 1), tmp);
        }
        for (i = 0; i < parent.size(); ++i) {
            this.rotateNode3((TreeElement)parent.get(i));
        }
    }

    public TreeElement rootOutgroup(TreeElement treeList, int id, boolean node) {
        this.nodoRaiz = null;
        this.nodoB = null;
        this.nodoRaiz = new TreeElement(true, 0, 0, 0.0, 0.0, null);
        this.nodoB = new TreeElement(true, 0, 0, this.getMinLength(treeList), 0.0, this.nodoRaiz);
        this.rootOutgroup2(treeList, id, node, this.isMultichotomy(treeList));
        this.nodoRaiz = this.reset(this.nodoRaiz);
        return this.nodoRaiz;
    }

    private void rootOutgroup2(TreeElement parent, int id, boolean node, boolean multichotomy) {
        if (parent.isNode() == node && parent.getId() == id) {
            TreeElement father = parent.getFather();
            parent.setFather(this.nodoRaiz);
            this.nodoRaiz.add(parent);
            this.nodoRaiz.add(this.nodoB);
            for (int i = 0; i < father.size(); ++i) {
                if ((TreeElement)father.get(i) == parent) continue;
                this.nodoB.add((TreeElement)father.get(i));
            }
            this.nodoB.add(this.getFathers(father, father.getBootstrap()));
            if (multichotomy) {
                this.nodoB.setBootstrap(father.getBootstrap());
            }
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.rootOutgroup2((TreeElement)parent.get(i), id, node, multichotomy);
        }
    }

    private TreeElement getFathers(TreeElement parent, double boot) {
        int i;
        TreeElement res = new TreeElement(true, 0, 0, parent.getLength(), boot, parent);
        TreeElement father = parent.getFather();
        if (father.getFather() == null) {
            if (father.size() > 2) {
                for (int i2 = 0; i2 < father.size(); ++i2) {
                    if (father.get(i2) == parent) continue;
                    res.add(father.get(i2));
                }
                return res;
            }
            for (i = 0; i < father.size(); ++i) {
                if (father.get(i) == parent) continue;
                return (TreeElement)father.get(i);
            }
        }
        for (i = 0; i < father.size(); ++i) {
            if (father.get(i) == parent) continue;
            res.add(father.get(i));
        }
        if (father.getFather() != null) {
            res.add(this.getFathers(father, father.getBootstrap()));
        }
        return res;
    }

    public double getMaxLength(TreeElement parent) {
        this.maxLength = 0.0;
        this.getMaxLength2(parent);
        return this.maxLength;
    }

    private void getMaxLength2(TreeElement parent) {
        double len = parent.getLength();
        if (len > this.maxLength) {
            this.maxLength = len;
        }
        Iterator iter = parent.iterator();
        while (iter.hasNext()) {
            this.getMaxLength2((TreeElement)iter.next());
        }
    }

    public double getMinLength(TreeElement treeList) {
        this.minLength = 1.0E8;
        this.getMinLength2(treeList);
        return this.minLength;
    }

    private void getMinLength2(TreeElement parent) {
        for (TreeElement child : parent) {
            double len = child.getLength();
            if (len < this.minLength) {
                this.minLength = len;
            }
            this.getMinLength2(child);
        }
    }

    public void showTree(TreeElement parent, String tab) {
        System.out.print((String)tab);
        System.out.print("[ " + parent.getText() + " ]");
        System.out.print(":");
        System.out.print(" id: " + parent.getId());
        System.out.print(" | x: " + parent.getX());
        System.out.print(" | y: " + parent.getY());
        System.out.print(" | length: " + parent.getLength());
        System.out.print(" | W: " + parent.getW());
        System.out.print(" | T: " + parent.getT());
        System.out.print(" | AR: " + parent.getAngleRight());
        System.out.print(" | AL: " + parent.getAngleLeft());
        tab = (String)tab + "\t";
        try {
            System.out.print(" | xP: " + parent.getFather().getX());
        }
        catch (Exception ex) {
            System.out.print(" | xP: 0");
        }
        System.out.print(" | visible: " + parent.isVisible());
        try {
            System.out.print(" | father: " + parent.getFather().getId());
        }
        catch (Exception ex) {
            System.out.print(" | father: null");
        }
        System.out.print("\n");
        for (int i = 0; i < parent.size(); ++i) {
            this.showTree((TreeElement)parent.get(i), (String)tab);
        }
    }

    public int getNumOtu(TreeElement treeList) {
        this.calcNumElements(treeList);
        return this.countOtu;
    }

    public int getNumNode(TreeElement treeList) {
        this.calcNumElements(treeList);
        return this.countNode;
    }

    private void calcNumElements(TreeElement treeList) {
        this.countOtu = 0;
        this.countNode = 0;
        this.calcNumElements2(treeList);
    }

    private void calcNumElements2(TreeElement parent) {
        if (parent.isNode()) {
            ++this.countNode;
        } else {
            ++this.countOtu;
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.calcNumElements2((TreeElement)parent.get(i));
        }
    }

    public TreeElement reset(TreeElement treeList) {
        this.countOtu = 0;
        this.countNode = 0;
        this.reset2(treeList, 0);
        return treeList;
    }

    private void reset2(TreeElement parent, int level) {
        if (parent.isNode()) {
            parent.setId(this.countNode++);
        }
        parent.setLevel(level);
        ++level;
        for (int i = 0; i < parent.size(); ++i) {
            ((TreeElement)parent.get(i)).setFather(parent);
            this.reset2((TreeElement)parent.get(i), level);
        }
    }

    public TreeElement copyTree(TreeElement treeList) {
        TreeElement copy = this.copyTree2(treeList);
        this.copyTree3(copy);
        return copy;
    }

    private TreeElement copyTree2(TreeElement parent) {
        TreeElement res = new TreeElement(parent.isNode(), parent.getId(), parent.getLevel(), parent.getLength(), parent.getBootstrap(), parent.getFather());
        res.setX(parent.getX());
        res.setY(parent.getY());
        res.setYChildLow(parent.getYChildLow());
        res.setYChildHigh(parent.getYChildHigh());
        res.setVisible(parent.isVisible());
        res.setLength(parent.getLength());
        res.setLevel(parent.getLevel());
        res.setRoot(parent.isRoot());
        res.setText(parent.getText());
        res.setLink(parent.getLink());
        res.setCluster(parent.getCluster());
        res.setFont(parent.getFont());
        res.setColorLine(parent.getColorLine());
        res.setColorText(parent.getColorText());
        res.setBorder(parent.getBorder());
        res.setColorBorder(parent.getColorBorder());
        res.setW(parent.getW());
        res.setT(parent.getT());
        Iterator iter = parent.iterator();
        while (iter.hasNext()) {
            res.add(this.copyTree2((TreeElement)iter.next()));
        }
        return res;
    }

    private void copyTree3(TreeElement parent) {
        int i;
        for (i = 0; i < parent.size(); ++i) {
            ((TreeElement)parent.get(i)).setFather(parent);
        }
        for (i = 0; i < parent.size(); ++i) {
            this.copyTree3((TreeElement)parent.get(i));
        }
    }

    public ImageDim getMaxDimension(TreeElement treeList) {
        this.imageDim.setSize(0.0, 0.0);
        this.getMaxDimension2(treeList);
        return this.imageDim;
    }

    private void getMaxDimension2(TreeElement parent) {
        double x = parent.getX();
        double y = parent.getY();
        if (this.imageDim.getWidth() > x) {
            x = this.imageDim.getWidth();
        }
        if (this.imageDim.getHeight() > y) {
            y = this.imageDim.getHeight();
        }
        this.imageDim.setSize(x, y);
        for (int i = 0; i < parent.size(); ++i) {
            if (!((TreeElement)parent.get(i)).isVisible()) continue;
            this.getMaxDimension2((TreeElement)parent.get(i));
        }
    }

    public TreeElement invert(TreeElement treeList, int maxWidth, double scaleFactorX) {
        this.invert2(treeList, maxWidth, scaleFactorX);
        return treeList;
    }

    private void invert2(TreeElement parent, int maxWidth, double scaleFactorX) {
        parent.setX((double)maxWidth / scaleFactorX - parent.getX());
        for (int i = 0; i < parent.size(); ++i) {
            this.invert2((TreeElement)parent.get(i), maxWidth, scaleFactorX);
        }
    }

    public boolean isMultichotomy(TreeElement treeList) {
        return treeList.size() > 2;
    }

    public double getMaxBootstrap(TreeElement treeList) {
        this.maxBootstrap = 0.0;
        this.getMaxBootstrap2(treeList);
        return this.maxBootstrap;
    }

    private void getMaxBootstrap2(TreeElement parent) {
        double boot;
        if (parent.isNode() && (boot = parent.getBootstrap()) > this.maxBootstrap) {
            this.maxBootstrap = boot;
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.getMaxBootstrap2((TreeElement)parent.get(i));
        }
    }

    public boolean hasDifferentOtuLength(TreeElement treeList) {
        boolean differentOtuLength = false;
        this.listOtuLength = new ArrayList();
        this.hasDifferentOtuLength2(treeList);
        for (int i = 0; i < this.listOtuLength.size(); ++i) {
            if (this.listOtuLength.get(i).equals(this.listOtuLength.get(0))) continue;
            differentOtuLength = true;
            break;
        }
        return differentOtuLength;
    }

    private void hasDifferentOtuLength2(TreeElement parent) {
        if (!parent.isNode()) {
            this.listOtuLength.add(String.valueOf(parent.getLength()));
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.hasDifferentOtuLength2((TreeElement)parent.get(i));
        }
    }

    public TreeElement makeParsimonia(TreeElement treeList) {
        this.makeParsimonia2(treeList);
        return treeList;
    }

    private void makeParsimonia2(TreeElement parent) {
        if (parent.isNode()) {
            parent.setBootstrap(parent.getLength());
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.makeParsimonia2((TreeElement)parent.get(i));
        }
    }

    public TreeElement setLength(TreeElement treeList, double length) {
        this.setLength2(treeList, length);
        return treeList;
    }

    private void setLength2(TreeElement parent, double length) {
        parent.setLength(length);
        for (int i = 0; i < parent.size(); ++i) {
            this.setLength2((TreeElement)parent.get(i), length);
        }
    }

    public void orderTree(TreeElement parent) {
        if (parent.isNode()) {
            int i;
            TreeElement[] tmp = new TreeElement[parent.size()];
            int maxDes = 0;
            for (i = 0; i < parent.size(); ++i) {
                tmp[i] = (TreeElement)parent.get(i);
            }
            for (i = 0; i < tmp.length; ++i) {
                if (tmp[i].getDescendantCount() <= maxDes) continue;
                maxDes = tmp[i].getDescendantCount();
            }
            for (i = 0; i < tmp.length - 1; ++i) {
                if (tmp[i].getDescendantCount() <= 1 || tmp[i + 1].getDescendantCount() != 1) continue;
                TreeElement aux = tmp[i];
                tmp[i] = tmp[i + 1];
                tmp[i + 1] = aux;
            }
            for (i = 0; i < tmp.length; ++i) {
                parent.set(i, tmp[i]);
            }
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.orderTree((TreeElement)parent.get(i));
        }
    }

    public int getMaxLevel(TreeElement treeList) {
        this.maxLevel = 0;
        this.getMaxLevel2(treeList);
        return this.maxLevel;
    }

    private void getMaxLevel2(TreeElement parent) {
        if (parent.getLevel() > this.maxLevel) {
            this.maxLevel = parent.getLevel();
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.getMaxLevel2((TreeElement)parent.get(i));
        }
    }

    public void setTotalLength(TreeElement parent) {
        double parentTotalLength = 0.0;
        try {
            parentTotalLength = parent.getFather().getTotalLength();
        }
        catch (Exception ex) {
            parentTotalLength = 0.0;
        }
        parent.setTotalLength(parent.getLength() + parentTotalLength);
        for (int i = 0; i < parent.size(); ++i) {
            this.setTotalLength((TreeElement)parent.get(i));
        }
    }

    public void setDescendantCount(TreeElement parent) {
        parent.setDescendantCount(this.getDescendantCount(parent));
        for (int i = 0; i < parent.size(); ++i) {
            this.setDescendantCount((TreeElement)parent.get(i));
        }
    }

    public int getDescendantCount(TreeElement parent) {
        this.descendantCount = 0;
        this.getDescendantCount2(parent);
        return this.descendantCount;
    }

    private void getDescendantCount2(TreeElement parent) {
        if (!parent.isNode()) {
            ++this.descendantCount;
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.getDescendantCount2((TreeElement)parent.get(i));
        }
    }

    public TreeElement getSibling(TreeElement parent) {
        TreeElement sibling = null;
        TreeElement father = parent.getFather();
        for (int i = 0; i < father.size(); ++i) {
            if (((TreeElement)father.get(i)).getId() == parent.getId() && ((TreeElement)father.get(i)).isNode() == parent.isNode()) continue;
            sibling = (TreeElement)father.get(i);
        }
        return sibling;
    }

    public TreeElement getSubtree(TreeElement treeList, int nodeId) {
        TreeElement subtree = this.getSubtree2(treeList, nodeId);
        return subtree;
    }

    private TreeElement getSubtree2(TreeElement parent, int nodeId) {
        TreeElement subtree = null;
        if (parent.isNode() && parent.getId() == nodeId) {
            subtree = this.getSubtree3(parent);
            subtree.setFather(null);
            subtree = this.reset(subtree);
            return subtree;
        }
        for (int i = 0; i < parent.size(); ++i) {
            TreeElement temp = this.getSubtree2((TreeElement)parent.get(i), nodeId);
            if (temp == null) continue;
            subtree = temp;
        }
        return subtree;
    }

    private TreeElement getSubtree3(TreeElement parent) {
        TreeElement res = new TreeElement(parent.isNode(), parent.getId(), parent.getLevel(), parent.getLength(), parent.getBootstrap(), parent.getFather());
        res.setX(parent.getX());
        res.setY(parent.getY());
        res.setYChildLow(parent.getYChildLow());
        res.setYChildHigh(parent.getYChildHigh());
        res.setVisible(parent.isVisible());
        res.setText(parent.getText());
        res.setLink(parent.getLink());
        res.setCluster(parent.getCluster());
        res.setFont(parent.getFont());
        res.setColorText(parent.getColorText());
        res.setBorder(parent.getBorder());
        res.setColorBorder(parent.getColorBorder());
        for (int i = 0; i < parent.size(); ++i) {
            res.add(this.copyTree2((TreeElement)parent.get(i)));
        }
        return res;
    }

    public void fitTreeToWindow(InternalF intf) {
        ImageDim myTreeDim = intf.getDim();
        double myWindowWidth = intf.getWidth() - 100;
        double myWindowHeight = intf.getHeight() - 100;
        if (intf.getTreeView().equalsIgnoreCase("unrooted")) {
            double minWindowSize = myWindowWidth;
            if (minWindowSize > myWindowHeight) {
                minWindowSize = myWindowHeight;
            }
            myWindowWidth = minWindowSize;
            myWindowHeight = minWindowSize;
        }
        double myScaleW = intf.getScaleFactorX();
        double myTreeWidth = myTreeDim.getWidth() - (double)(intf.getMarginX() * 2);
        double myNewFactorW = myWindowWidth / myTreeWidth;
        double myScaleH = intf.getScaleFactorY();
        double myTreeHeight = myTreeDim.getHeight() - (double)(intf.getMarginY() * 2);
        double myNewFactorH = myWindowHeight / myTreeHeight;
        intf.setScaleFactorX(myScaleW * myNewFactorW);
        intf.setScaleFactorY(myScaleH * myNewFactorH);
        intf.moveScale();
    }

    public TreeElement pivotTree(TreeElement treeList, int nodeNum) {
        System.out.println("treeutils pivota");
        this.pivotTree2(treeList, nodeNum);
        return treeList;
    }

    private void pivotTree2(TreeElement parent, int nodeNum) {
        if (parent.isNode() && parent.getId() == nodeNum) {
            System.out.println("T:" + parent.getT());
            System.out.println("W:" + parent.getW());
            this.pivotTree3(parent);
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.pivotTree2((TreeElement)parent.get(i), nodeNum);
        }
    }

    private void pivotTree3(TreeElement parent) {
        parent.setX(parent.getX() + 3.0);
        parent.setY(parent.getY() + 3.0);
        for (int i = 0; i < parent.size(); ++i) {
            this.pivotTree3((TreeElement)parent.get(i));
        }
    }

    public void resetLevel(TreeElement parent, int level) {
        parent.setLevel(level);
        ++level;
        Iterator iter = parent.iterator();
        while (iter.hasNext()) {
            this.resetLevel((TreeElement)iter.next(), level);
        }
    }

    public void resetId(TreeElement treeList) {
        this.countOtu = 0;
        this.countNode = 0;
        this.resetId2(treeList);
    }

    private void resetId2(TreeElement parent) {
        if (parent.isNode()) {
            parent.setId(this.countNode++);
        } else {
            parent.setId(this.countOtu++);
        }
        Iterator iter = parent.iterator();
        while (iter.hasNext()) {
            this.resetId2((TreeElement)iter.next());
        }
    }

    public void resetFather(TreeElement parent, TreeElement father) {
        parent.setFather(father);
        Iterator iter = parent.iterator();
        while (iter.hasNext()) {
            this.resetFather((TreeElement)iter.next(), parent);
        }
    }

    public double getMinY(TreeElement treeList) {
        this.minY = 999999.0;
        this.getMinY2(treeList);
        return this.minY;
    }

    private void getMinY2(TreeElement parent) {
        if (parent.getY() < this.minY) {
            this.minY = parent.getY();
        }
        Iterator iter = parent.iterator();
        while (iter.hasNext()) {
            this.getMinY2((TreeElement)iter.next());
        }
    }

    public double getMaxY(TreeElement treeList) {
        this.maxY = 0.0;
        this.getMaxY2(treeList);
        return this.maxY;
    }

    private void getMaxY2(TreeElement parent) {
        if (parent.getY() > this.maxY) {
            this.maxY = parent.getY();
        }
        Iterator iter = parent.iterator();
        while (iter.hasNext()) {
            this.getMaxY2((TreeElement)iter.next());
        }
    }
}

