/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph;

import java.util.ArrayList;
import java.util.List;

public class NexusToNewick {
    private String tree;

    public NexusToNewick(String nexus) {
        this.tree = this.getTreeString(nexus);
    }

    private String getTreeString(String nexus) {
        String res = "";
        String[] line = nexus.split("\n");
        for (int i = 0; i < line.length; ++i) {
            if (line[i].indexOf("tree") == -1) continue;
            res = line[i].substring(line[i].indexOf("=") + 1).trim();
            res = line[i].substring(line[i].indexOf("]") + 1).trim();
        }
        return res;
    }

    private String[] getTable(String nexus) {
        int i;
        ArrayList res = new ArrayList();
        String[] line = nexus.split("\n");
        StringBuffer stringBuffer = new StringBuffer();
        String label = null;
        boolean write = false;
        String[] otuName = null;
        for (int i2 = 0; i2 < line.length; ++i2) {
            if (write) {
                stringBuffer.append(line[i2]);
            }
            if (line[i2].trim().equals(";")) {
                write = false;
            }
            if (!line[i2].trim().equals("TRANSLATE")) continue;
            write = true;
        }
        label = stringBuffer.toString();
        int pos = label.indexOf(";");
        label = label.substring(0, pos);
        label = label.trim();
        String[] commas = label.split(",");
        for (i = 0; i < commas.length; ++i) {
            commas[i] = commas[i].trim();
        }
        otuName = new String[commas.length];
        for (i = 0; i < commas.length; ++i) {
            int posTab = commas[i].indexOf("\t");
            if (posTab == -1) continue;
            String index = commas[i].substring(0, posTab).trim();
            String otuLabel = commas[i].substring(posTab + 1).trim();
            int posOpenQuote = otuLabel.indexOf("'");
            int posCloseQuote = otuLabel.lastIndexOf("'");
            if (posOpenQuote != -1 && posCloseQuote != -1 && posOpenQuote != posCloseQuote) {
                otuLabel = otuLabel.substring(posOpenQuote + 1, posCloseQuote);
            }
            otuName[Integer.parseInt((String)index) - 1] = otuLabel;
        }
        return otuName;
    }

    private String replaceOtuNames(String[] listNames, String tree) {
        String[] commas = tree.split(",");
        String output = "";
        StringBuffer sbuffer = new StringBuffer();
        for (int i = 0; i < commas.length; ++i) {
            int colon;
            String text = "";
            String otu = "";
            String nodeInfo = "";
            int openPar = commas[i].lastIndexOf("(");
            int closePar = commas[i].indexOf(")");
            text = openPar != -1 ? commas[i].substring(openPar + 1) : commas[i];
            if (closePar != -1) {
                text = text.substring(0, closePar);
            }
            otu = (colon = text.indexOf(":")) != -1 ? text.substring(0, colon) : text;
            if (openPar != -1) {
                sbuffer.append(commas[i].substring(0, openPar + 1));
            }
            sbuffer.append(listNames[Integer.parseInt(otu) - 1]);
            if (closePar != -1) {
                sbuffer.append(commas[i].substring(closePar));
            }
            sbuffer.append(",");
        }
        output = sbuffer.toString();
        int lastComma = output.lastIndexOf(",");
        output = output.substring(0, lastComma);
        return output;
    }

    private String searchListName(List<?> listNames, String num) {
        for (int i = 0; i < listNames.size(); ++i) {
            if (!((String[])listNames.get(i))[0].equals(num)) continue;
            return ((String[])listNames.get(i))[1];
        }
        return null;
    }

    private String replaceBootstrap(String tree) {
        int i;
        StringBuffer res = new StringBuffer();
        String[] part = tree.split(":");
        for (i = 0; i < part.length; ++i) {
            if (part[i].indexOf("[") == -1) continue;
            part[i] = this.moveBootstrap(part[i]);
        }
        for (i = 0; i < part.length - 1; ++i) {
            if (part[i + 1].indexOf(":") != -1) {
                res.append(part[i]);
                continue;
            }
            res.append(part[i] + ":");
        }
        res.append(part[part.length - 1]);
        return res.toString();
    }

    private String moveBootstrap(String input) {
        StringBuffer res = new StringBuffer();
        int posIni = input.indexOf("[");
        int posFin = input.indexOf("]");
        if (posIni != -1) {
            String boot = input.substring(posIni + 1, posFin);
            res.append(boot + ":" + input.substring(0, posIni) + input.substring(posFin + 1));
        } else if (input.charAt(input.length() - 1) == ')') {
            res.append(input);
        } else {
            res.append(input + ":");
        }
        return res.toString();
    }

    public String getNewick() {
        return this.tree;
    }
}

