/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph;

import com.biotechvana.phylograph.TreeElement;
import java.util.ArrayList;

class NewickToList {
    private int countOtu = 0;
    private int countNode = 0;
    private TreeElement treeList;

    public NewickToList(String newick) {
        newick = this.cleanNewick(newick);
        this.treeList = newick == null ? null : this.createList(newick, 0, null);
    }

    private String cleanNewick(String newick) {
        int firstP = newick.indexOf("(");
        int lastP = newick.lastIndexOf(")");
        String output = newick.substring(firstP, lastP + 1);
        output = output.replaceAll("\r", "");
        output = output.replaceAll("\n", "");
        return output;
    }

    private TreeElement createList(String newick, int level, TreeElement father) {
        TreeElement element;
        int pos = newick.indexOf(",");
        if (pos == -1) {
            int id = this.countOtu++;
            double length = -1.0;
            pos = newick.indexOf(":");
            if (pos != -1) {
                try {
                    length = Double.parseDouble(newick.substring(pos + 1));
                }
                catch (Exception ex) {
                    length = 1000.0;
                }
                newick = newick.substring(0, pos);
            } else {
                length = 1000.0;
            }
            String text = newick.trim();
            try {
                if (text.charAt(0) == '\'') {
                    text = text.substring(1);
                }
                if (text.charAt(text.length() - 1) == '\'') {
                    text = text.substring(0, text.length() - 1);
                }
            }
            catch (Exception e) {
                System.out.println("No text nodes");
            }
            element = new TreeElement(false, id, level, length, 0.0, father);
            element.setText(text);
        } else {
            int i;
            String nodeInfo;
            int id = this.countNode++;
            double length = -1.0;
            double bootstrap = 0.0;
            pos = newick.indexOf("(");
            if (pos == 1) {
                newick = newick.substring(1);
                pos = newick.indexOf("(");
            }
            if ((pos = (nodeInfo = newick.substring(newick.lastIndexOf(")") + 1)).indexOf(":")) != -1) {
                try {
                    length = Double.parseDouble(nodeInfo.substring(pos + 1));
                }
                catch (Exception ex) {
                    length = 1000.0;
                }
                try {
                    bootstrap = Double.parseDouble(nodeInfo.substring(0, pos));
                }
                catch (Exception ex) {
                    bootstrap = 0.0;
                }
            } else {
                length = level == 0 ? 0.0 : 100.0;
            }
            element = new TreeElement(true, id, level, length, bootstrap, father);
            if (newick.lastIndexOf(")") != -1) {
                newick = newick.substring(0, newick.lastIndexOf(")"));
            }
            newick = newick.substring(1);
            ArrayList<Object> tab = new ArrayList<Object>();
            int j = 0;
            int nivel = 0;
            tab.add(0, "");
            for (i = 0; i < newick.length(); ++i) {
                if (newick.charAt(i) == '(') {
                    ++nivel;
                } else if (newick.charAt(i) == ')') {
                    --nivel;
                }
                if (nivel == 0 && newick.charAt(i) == ',') {
                    tab.add(++j, "");
                    continue;
                }
                tab.set(j, ((String)tab.get(j)).toString() + newick.charAt(i));
            }
            ++level;
            for (i = 0; i < tab.size(); ++i) {
                TreeElement child = this.createList(((String)tab.get(i)).toString(), level, element);
                element.add(child);
            }
        }
        return element;
    }

    public TreeElement getTreeList() {
        return this.treeList;
    }
}

