/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph;

import com.biotechvana.phylograph.TreeElement;

public class ListToNexus {
    private StringBuffer sbuffer;

    public String getNexusString(TreeElement treeList, boolean hasBootstrap) {
        this.sbuffer = new StringBuffer();
        this.sbuffer.append("#NEXUS\n");
        this.sbuffer.append("begin trees;\n");
        this.sbuffer.append("tree tree1 = ");
        this.createNexus2(treeList, hasBootstrap);
        this.sbuffer.append(";\n");
        this.sbuffer.append("end;");
        return this.sbuffer.toString();
    }

    private void createNexus2(TreeElement parent, boolean hasBootstrap) {
        if (parent.isNode()) {
            this.sbuffer.append("(");
        } else {
            this.sbuffer.append(parent.getText());
            this.sbuffer.append(":" + parent.getLength());
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.createNexus2((TreeElement)parent.get(i), hasBootstrap);
            this.sbuffer.append(",");
        }
        if (parent.isNode()) {
            if (this.sbuffer.charAt(this.sbuffer.length() - 1) == ',') {
                this.sbuffer = new StringBuffer(this.sbuffer.substring(0, this.sbuffer.length() - 1));
            }
            this.sbuffer.append(")");
            if (hasBootstrap) {
                this.sbuffer.append(parent.getBootstrap());
            }
            this.sbuffer.append(":" + parent.getLength());
        }
    }
}

