/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.phylograph;

import com.biotechvana.phylograph.TreeElement;

public class ListToJson {
    private StringBuffer sbuffer;
    private int level;

    public String getJsonString(TreeElement treeList, boolean hasBootstrap) {
        this.sbuffer = new StringBuffer();
        this.sbuffer.append("{\n");
        this.sbuffer.append("\"root\": ");
        this.createJson2(treeList, hasBootstrap);
        this.sbuffer.append("\n}");
        return this.sbuffer.toString();
    }

    public void printTabulations(TreeElement parent) {
        this.level = parent.getLevel() + 1;
        for (int i = 0; i < this.level; ++i) {
            this.sbuffer.append("\t");
        }
    }

    private void createJson2(TreeElement parent, boolean hasBootstrap) {
        if (parent.isNode()) {
            if (!parent.isRoot()) {
                this.printTabulations(parent);
            }
            this.sbuffer.append("{\n");
            this.printTabulations(parent);
            this.sbuffer.append(" \"children\": [\n");
        } else {
            this.printTabulations(parent);
            this.sbuffer.append("{\n");
            this.printTabulations(parent);
            this.sbuffer.append(" \"name\": " + parent.getText() + ",\n");
            this.printTabulations(parent);
            this.sbuffer.append(" \"length\": " + parent.getLength() + "\n");
            this.printTabulations(parent);
            this.sbuffer.append("}");
        }
        for (int i = 0; i < parent.size(); ++i) {
            this.createJson2((TreeElement)parent.get(i), hasBootstrap);
            this.sbuffer.append(",\n");
        }
        if (parent.isNode()) {
            if (this.sbuffer.charAt(this.sbuffer.length() - 2) == ',') {
                this.sbuffer = new StringBuffer(this.sbuffer.substring(0, this.sbuffer.length() - 2));
                this.sbuffer.append("\n");
            }
            this.printTabulations(parent);
            this.sbuffer.append(" ],\n");
            if (hasBootstrap) {
                this.printTabulations(parent);
                this.sbuffer.append(" \"bootstrap\":" + parent.getBootstrap() + ",\n");
            }
            this.printTabulations(parent);
            this.sbuffer.append(" \"length\":" + parent.getLength() + "\n");
            this.printTabulations(parent);
            this.sbuffer.append("}");
        }
    }
}

